/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.argument;

import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.ArgumentDescription;
import squaremap.libraries.cloud.commandframework.arguments.CommandArgument;
import squaremap.libraries.cloud.commandframework.arguments.parser.ArgumentParseResult;
import squaremap.libraries.cloud.commandframework.arguments.parser.ArgumentParser;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.argument.MapWorldArgument;
import xyz.jpenilla.squaremap.common.util.Util;

public final class LevelArgument<C>
extends CommandArgument<C, WorldServer> {
    private LevelArgument(boolean required, String name, String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, ArgumentDescription defaultDescription) {
        super(required, name, new Parser(), defaultValue, WorldServer.class, suggestionsProvider, defaultDescription);
    }

    public static <C> Builder<C> builder(String name) {
        return new Builder(name);
    }

    public static <C> LevelArgument<C> of(String name) {
        return LevelArgument.builder(name).build();
    }

    public static <C> LevelArgument<C> optional(String name) {
        return ((Builder)LevelArgument.builder(name).asOptional()).build();
    }

    public static <C> LevelArgument<C> optional(String name, String defaultValue) {
        return ((Builder)LevelArgument.builder(name).asOptionalWithDefault(defaultValue)).build();
    }

    public static final class Parser<C>
    implements ArgumentParser<C, WorldServer> {
        @Override
        public ArgumentParseResult<WorldServer> parse(CommandContext<C> commandContext, Queue<String> inputQueue) {
            @Nullable String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(Parser.class, commandContext));
            }
            @Nullable MinecraftKey key = MinecraftKey.a((String)input);
            if (key == null || key.a().isEmpty()) {
                return ArgumentParseResult.failure(new MapWorldArgument.MapWorldParseException(input, MapWorldArgument.MapWorldParseException.FailureReason.NO_SUCH_WORLD));
            }
            @Nullable WorldServer world = commandContext.get(Commands.SERVER_ACCESS).level(Util.worldIdentifier(key));
            if (world == null) {
                return ArgumentParseResult.failure(new MapWorldArgument.MapWorldParseException(input, MapWorldArgument.MapWorldParseException.FailureReason.NO_SUCH_WORLD));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(world);
        }

        @Override
        public List<String> suggestions(CommandContext<C> commandContext, String input) {
            return commandContext.get(Commands.SERVER_ACCESS).levels().stream().flatMap(mapWorld -> {
                MinecraftKey identifier = mapWorld.ac().a();
                if (!input.isBlank() && identifier.b().equals("minecraft")) {
                    return Stream.of(identifier.a(), identifier.toString());
                }
                return Stream.of(identifier.toString());
            }).toList();
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, WorldServer, Builder<C>> {
        private Builder(String name) {
            super(WorldServer.class, name);
        }

        public LevelArgument<C> build() {
            return new LevelArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

