/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.util.ComponentMessageThrowable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.CommandManager;
import squaremap.libraries.cloud.commandframework.exceptions.ArgumentParseException;
import squaremap.libraries.cloud.commandframework.exceptions.CommandExecutionException;
import squaremap.libraries.cloud.commandframework.exceptions.InvalidCommandSenderException;
import squaremap.libraries.cloud.commandframework.exceptions.InvalidSyntaxException;
import squaremap.libraries.cloud.commandframework.exceptions.NoPermissionException;
import squaremap.libraries.cloud.commandframework.exceptions.parsing.ParserException;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.spongepowered.configurate.util.NamingSchemes;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.exception.CommandCompleted;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Components;

final class ExceptionHandler {
    @Inject
    private ExceptionHandler() {
    }

    public void registerExceptionHandlers(CommandManager<Commander> manager) {
        manager.registerExceptionHandler(CommandExecutionException.class, this::commandExecution);
        manager.registerExceptionHandler(NoPermissionException.class, this::noPermission);
        manager.registerExceptionHandler(ArgumentParseException.class, this::argumentParsing);
        manager.registerExceptionHandler(InvalidCommandSenderException.class, this::invalidSender);
        manager.registerExceptionHandler(InvalidSyntaxException.class, this::invalidSyntax);
    }

    private void commandExecution(Commander commander, CommandExecutionException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof CommandCompleted) {
            CommandCompleted completed = (CommandCompleted)cause;
            @Nullable Component message = completed.componentMessage();
            if (message != null) {
                commander.sendMessage(message);
            }
            return;
        }
        Logging.logger().warn("An unexpected error occurred during command execution", cause);
        TextComponent.Builder message = Component.text();
        message.append((ComponentLike)Messages.COMMAND_EXCEPTION_COMMAND_EXECUTION);
        if (commander.hasPermission("squaremap.command-exception-stacktrace")) {
            ExceptionHandler.decorateWithHoverStacktrace(message, cause);
        }
        ExceptionHandler.decorateAndSend(commander, (ComponentLike)message);
    }

    private void noPermission(Commander commander, NoPermissionException exception) {
        ExceptionHandler.decorateAndSend(commander, Messages.COMMAND_EXCEPTION_NO_PERMISSION);
    }

    private void argumentParsing(Commander commander, ArgumentParseException exception) {
        Component message;
        Throwable cause = exception.getCause();
        Supplier<Component> fallback = () -> Objects.requireNonNull(ExceptionHandler.componentMessage(cause));
        if (cause instanceof ParserException) {
            Component fromConfig;
            ParserException parserException = (ParserException)cause;
            TagResolver[] placeholders = (TagResolver[])Arrays.stream(parserException.captionVariables()).map(variable -> Components.placeholder(NamingSchemes.SNAKE_CASE.coerce(variable.getKey()), variable.getValue())).toArray(TagResolver[]::new);
            String key = "command.message.parser-exception." + parserException.errorCaption().getKey().replace("argument.parse.failure.", "");
            try {
                fromConfig = Messages.componentMessage(key).withPlaceholders(placeholders);
            }
            catch (Exception ex) {
                Logging.logger().warn("Could not get message with key '{}'", (Object)key, (Object)ex);
                fromConfig = null;
            }
            message = fromConfig != null ? fromConfig : fallback.get();
        } else {
            message = fallback.get();
        }
        ExceptionHandler.decorateAndSend(commander, (ComponentLike)Messages.COMMAND_EXCEPTION_INVALID_ARGUMENT.withPlaceholders(new TagResolver[]{Components.placeholder("message", (ComponentLike)message)}));
    }

    private void invalidSender(Commander commander, InvalidCommandSenderException exception) {
        Component message = Messages.COMMAND_EXCEPTION_INVALID_SENDER_TYPE.withPlaceholders(new TagResolver[]{Components.placeholder("required_sender_type", (ComponentLike)Component.text((String)exception.getRequiredSender().getSimpleName()))});
        ExceptionHandler.decorateAndSend(commander, (ComponentLike)message);
    }

    private void invalidSyntax(Commander commander, InvalidSyntaxException exception) {
        Component message = Messages.COMMAND_EXCEPTION_INVALID_SYNTAX.withPlaceholders(new TagResolver[]{Components.placeholder("correct_syntax", (ComponentLike)Components.highlightSpecialCharacters((Component)Component.text((String)"/%s".formatted(exception.getCorrectSyntax())), (TextColor)NamedTextColor.WHITE))});
        ExceptionHandler.decorateAndSend(commander, (ComponentLike)message);
    }

    private static void decorateAndSend(Audience audience, ComponentLike componentLike) {
        TextComponent message = Component.textOfChildren((ComponentLike[])new ComponentLike[]{Messages.COMMAND_PREFIX.asComponent().hoverEvent((HoverEventSource)Messages.CLICK_FOR_HELP.asComponent()).clickEvent(ClickEvent.runCommand((String)"/%s help".formatted(Config.MAIN_COMMAND_LABEL))), componentLike});
        audience.sendMessage((Component)message);
    }

    private static void decorateWithHoverStacktrace(TextComponent.Builder message, Throwable cause) {
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString().replaceAll("\t", "    ");
        TextComponent.Builder hoverText = Component.text();
        @Nullable Component throwableMessage = ExceptionHandler.componentMessage(cause);
        if (throwableMessage != null) {
            ((TextComponent.Builder)((TextComponent.Builder)hoverText.append(throwableMessage)).append((Component)Component.newline())).append((Component)Component.newline());
        }
        ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)hoverText.append((Component)Component.text((String)stackTrace))).append((Component)Component.newline())).append((Component)Component.text((String)"    "))).append(Messages.CLICK_TO_COPY.asComponent().color((TextColor)NamedTextColor.GRAY).decorate(TextDecoration.ITALIC));
        message.hoverEvent((HoverEventSource)hoverText.build());
        message.clickEvent(ClickEvent.copyToClipboard((String)stackTrace));
    }

    private static @Nullable Component componentMessage(Throwable cause) {
        if (cause instanceof ComponentMessageThrowable || !(cause instanceof CommandSyntaxException)) {
            return ComponentMessageThrowable.getOrConvertMessage((Throwable)cause);
        }
        CommandSyntaxException commandSyntaxException = (CommandSyntaxException)cause;
        IChatBaseComponent component = ChatComponentUtils.a((Message)commandSyntaxException.getRawMessage());
        return GsonComponentSerializer.gson().deserializeFromTree(IChatBaseComponent.ChatSerializer.c((IChatBaseComponent)component));
    }
}

