/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import javax.imageio.ImageIO;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Injector;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.common.AbstractPlayerManager;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.SquaremapPlatform;
import xyz.jpenilla.squaremap.common.WorldManagerImpl;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.ConfigManager;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.LevelBiomeColorData;
import xyz.jpenilla.squaremap.common.httpd.IntegratedServer;
import xyz.jpenilla.squaremap.common.layer.SpawnIconLayer;
import xyz.jpenilla.squaremap.common.util.Components;
import xyz.jpenilla.squaremap.common.util.ReflectionUtil;
import xyz.jpenilla.squaremap.common.util.SquaremapJarAccess;
import xyz.jpenilla.squaremap.common.util.UpdateChecker;

@Singleton
public final class SquaremapCommon {
    private final Injector injector;
    private final SquaremapPlatform platform;
    private final DirectoryProvider directoryProvider;
    private final ConfigManager configManager;
    private final AbstractPlayerManager playerManager;
    private final WorldManagerImpl worldManager;
    private final Commands commands;
    private final SquaremapJarAccess squaremapJar;

    @Inject
    private SquaremapCommon(Injector injector, SquaremapPlatform platform, DirectoryProvider directoryProvider, ConfigManager configManager, AbstractPlayerManager playerManager, WorldManagerImpl worldManager, Commands commands, SquaremapJarAccess squaremapJar) {
        this.injector = injector;
        this.platform = platform;
        this.directoryProvider = directoryProvider;
        this.configManager = configManager;
        this.playerManager = playerManager;
        this.worldManager = worldManager;
        this.commands = commands;
        this.squaremapJar = squaremapJar;
    }

    public void init() {
        this.configManager.init();
        this.directoryProvider.init();
        this.start();
        this.setupApi();
        this.commands.registerCommands();
    }

    private void start() {
        this.squaremapJar.extract("web", this.directoryProvider.webDirectory(), Config.UPDATE_WEB_DIR);
        LevelBiomeColorData.loadImages(this.directoryProvider);
        this.worldManager.start();
        this.platform.startCallback();
        if (Config.HTTPD_ENABLED) {
            IntegratedServer.startServer(this.directoryProvider);
        } else {
            Logging.logger().info(Messages.LOG_INTERNAL_WEB_DISABLED);
        }
    }

    private void stop() {
        if (Config.HTTPD_ENABLED) {
            IntegratedServer.stopServer();
        }
        this.platform.stopCallback();
        this.worldManager.shutdown();
    }

    public void reload(Audience audience) {
        this.stop();
        this.configManager.reload();
        this.playerManager.reload();
        this.start();
        Component success = Messages.PLUGIN_RELOADED.withPlaceholders(new TagResolver[]{Components.placeholder("name", "squaremap"), Components.placeholder("version", this.platform.version())});
        audience.sendMessage(success);
    }

    public void updateCheck() {
        if (!Config.UPDATE_CHECKER) {
            return;
        }
        ForkJoinPool.commonPool().execute(() -> new UpdateChecker(Logging.logger(), "jpenilla/squaremap").checkVersion());
    }

    private void setupApi() {
        Squaremap api = this.injector.getInstance(Squaremap.class);
        try {
            api.iconRegistry().register(SpawnIconLayer.KEY, ImageIO.read(this.directoryProvider.webDirectory().resolve("images/icon/spawn.png").toFile()));
        }
        catch (IOException ex) {
            Logging.logger().warn("Failed to register spawn icon", (Throwable)ex);
        }
        Method register = ReflectionUtil.needMethod(SquaremapProvider.class, List.of("register"), Squaremap.class);
        ReflectionUtil.invokeOrThrow(register, null, api);
    }

    private void shutdownApi() {
        Method unregister = ReflectionUtil.needMethod(SquaremapProvider.class, List.of("unregister"), new Class[0]);
        ReflectionUtil.invokeOrThrow(unregister, null, new Object[0]);
    }

    public void shutdown() {
        this.shutdownApi();
        this.stop();
    }
}

