/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common;

import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.jpenilla.squaremap.common.config.Config;

public final class Logging {
    private static final Logger LOGGER = LogManager.getLogger((String)"squaremap");

    private Logging() {
    }

    public static Logger logger() {
        return LOGGER;
    }

    public static void debug(Supplier<String> msg) {
        if (Config.DEBUG_MODE) {
            Logging.logger().info("[DEBUG] " + msg.get());
        }
    }

    public static void error(String message, Throwable thr, Object ... replacements) {
        Logging.logger().error(Logging.replace(message, replacements), thr);
    }

    public static void info(String message, Object ... replacements) {
        Logging.logger().info(Logging.replace(message, replacements));
    }

    public static String replace(String message, Object ... replacements) {
        if (replacements.length == 0) {
            return message;
        }
        if ((replacements.length & 1) != 0) {
            throw new IllegalArgumentException("Invalid length for replacements array (expected to be divisible by 2)");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            message = message.replace("<" + replacements[i].toString() + ">", replacements[i + 1].toString());
        }
        return message;
    }
}

