/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.LayerProvider;
import xyz.jpenilla.squaremap.api.Pair;
import xyz.jpenilla.squaremap.api.Registry;

public final class LayerRegistry
implements Registry<LayerProvider> {
    private final Map<Key, LayerProvider> layerProviders = new ConcurrentHashMap<Key, LayerProvider>();

    @Override
    public void register(Key key, LayerProvider value) {
        if (this.hasEntry(key)) {
            throw LayerRegistry.layerAlreadyRegistered(key);
        }
        this.layerProviders.put(key, value);
    }

    @Override
    public void unregister(Key key) {
        LayerProvider removed = this.layerProviders.remove(key);
        if (removed == null) {
            throw LayerRegistry.noLayerRegistered(key);
        }
    }

    @Override
    public boolean hasEntry(Key key) {
        return this.layerProviders.containsKey(key);
    }

    @Override
    public LayerProvider get(Key key) {
        LayerProvider provider = this.layerProviders.get(key);
        if (provider == null) {
            throw LayerRegistry.noLayerRegistered(key);
        }
        return provider;
    }

    @Override
    public Iterable<Pair<Key, LayerProvider>> entries() {
        return this.layerProviders.entrySet().stream().map(entry -> Pair.of((Key)entry.getKey(), (LayerProvider)entry.getValue())).toList();
    }

    private static IllegalArgumentException noLayerRegistered(Key key) {
        return new IllegalArgumentException(String.format("No LayerProvider registered for key '%s'", key.getKey()));
    }

    private static IllegalArgumentException layerAlreadyRegistered(Key key) {
        throw new IllegalArgumentException(String.format("LayerProvider already registered for key '%s'", key.getKey()));
    }
}

