/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.Pair;
import xyz.jpenilla.squaremap.api.Registry;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.util.FileUtil;

public final class IconRegistry
implements Registry<BufferedImage> {
    private final Map<Key, BufferedImage> images = new ConcurrentHashMap<Key, BufferedImage>();
    private final Path directory;

    public IconRegistry(DirectoryProvider directoryProvider) {
        this.directory = directoryProvider.webDirectory().resolve("images/icon/registered/");
        try {
            if (Files.exists(this.directory, new LinkOption[0])) {
                FileUtil.deleteRecursively(this.directory);
            }
            Files.createDirectories(this.directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw IconRegistry.failedToCreateRegistry(e);
        }
    }

    @Override
    public void register(Key key, BufferedImage value) {
        if (this.hasEntry(key)) {
            throw IconRegistry.imageAlreadyRegistered(key);
        }
        try {
            ImageIO.write((RenderedImage)value, "png", this.directory.resolve(key.getKey() + ".png").toFile());
        }
        catch (IOException e) {
            throw IconRegistry.failedToWriteImage(key, e);
        }
        this.images.put(key, value);
    }

    @Override
    public void unregister(Key key) {
        BufferedImage removed = this.images.remove(key);
        if (removed == null) {
            throw IconRegistry.noImageRegistered(key);
        }
    }

    @Override
    public boolean hasEntry(Key key) {
        return this.images.containsKey(key);
    }

    @Override
    public BufferedImage get(Key key) {
        BufferedImage provider = this.images.get(key);
        if (provider == null) {
            throw IconRegistry.noImageRegistered(key);
        }
        return provider;
    }

    @Override
    public Iterable<Pair<Key, BufferedImage>> entries() {
        return this.images.entrySet().stream().map(entry -> Pair.of((Key)entry.getKey(), (BufferedImage)entry.getValue())).toList();
    }

    private static IllegalArgumentException failedToCreateRegistry(IOException e) {
        return new IllegalArgumentException("Failed to setup icon registry", e);
    }

    private static IllegalArgumentException failedToWriteImage(Key key, IOException e) {
        return new IllegalArgumentException(String.format("Failed to write image for key '%s'", key.getKey()), e);
    }

    private static IllegalArgumentException noImageRegistered(Key key) {
        return new IllegalArgumentException(String.format("No image registered for key '%s'", key.getKey()));
    }

    private static IllegalArgumentException imageAlreadyRegistered(Key key) {
        throw new IllegalArgumentException(String.format("Image already registered for key '%s'", key.getKey()));
    }
}

