/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.EntityPlayer;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.api.PlayerManager;
import xyz.jpenilla.squaremap.common.ServerAccess;

public abstract class AbstractPlayerManager
implements PlayerManager {
    private final ServerAccess serverAccess;
    private final Set<UUID> hidden = ConcurrentHashMap.newKeySet();

    protected AbstractPlayerManager(ServerAccess serverAccess) {
        this.serverAccess = serverAccess;
    }

    public boolean otherwiseHidden(EntityPlayer player) {
        return false;
    }

    public abstract Component displayName(EntityPlayer var1);

    protected abstract boolean persistentHidden(EntityPlayer var1);

    protected abstract void persistentHidden(EntityPlayer var1, boolean var2);

    @Override
    public final void hide(UUID uuid, boolean persistent) {
        this.hide(this.requirePlayer(uuid), persistent);
    }

    public final void hide(EntityPlayer player, boolean persistent) {
        if (persistent) {
            this.persistentHidden(player, true);
        }
        this.hidden.add(player.cv());
    }

    @Override
    public final void show(UUID uuid, boolean persistent) {
        this.show(this.requirePlayer(uuid), persistent);
    }

    public final void show(EntityPlayer player, boolean persistent) {
        if (persistent) {
            this.persistentHidden(player, false);
        }
        this.hidden.remove(player.cv());
    }

    @Override
    public final void hidden(UUID uuid, boolean hide, boolean persistent) {
        this.hidden(this.requirePlayer(uuid), hide, persistent);
    }

    @Override
    public final boolean hidden(UUID uuid) {
        return this.hidden(this.requirePlayer(uuid));
    }

    public final void reload() {
        this.hidden.clear();
    }

    public final boolean hidden(EntityPlayer player) {
        return this.hidden.contains(player.cv()) || this.persistentHidden(player);
    }

    public final void hidden(EntityPlayer player, boolean hide, boolean persistent) {
        if (hide) {
            this.hide(player, persistent);
        } else {
            this.show(player, persistent);
        }
    }

    private EntityPlayer requirePlayer(UUID uuid) {
        @Nullable EntityPlayer player = this.serverAccess.player(uuid);
        if (player == null) {
            throw new IllegalArgumentException("Player with uuid '" + uuid + "' is not online.");
        }
        return player;
    }
}

