/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.spongepowered.configurate.serialize;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.io.leangen.geantyref.GenericTypeReflector;
import squaremap.libraries.org.spongepowered.configurate.serialize.AbstractListChildSerializer;
import squaremap.libraries.org.spongepowered.configurate.serialize.Scalars;
import squaremap.libraries.org.spongepowered.configurate.serialize.SerializationException;
import squaremap.libraries.org.spongepowered.configurate.util.CheckedConsumer;
import squaremap.libraries.org.spongepowered.configurate.util.Types;

abstract class ArraySerializer<T>
extends AbstractListChildSerializer<T> {
    ArraySerializer() {
    }

    @Override
    protected Type elementType(Type containerType) throws SerializationException {
        Type componentType = GenericTypeReflector.getArrayComponentType(containerType);
        if (componentType == null) {
            throw new SerializationException(containerType, "Must be array type");
        }
        return componentType;
    }

    static final class Doubles
    extends ArraySerializer<double[]> {
        static final Class<double[]> TYPE = double[].class;

        Doubles() {
        }

        @Override
        protected double[] createNew(int length, Type elementType) {
            return new double[length];
        }

        @Override
        protected void forEachElement(double[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (double b : collection) {
                action.accept(b);
            }
        }

        @Override
        protected void deserializeSingle(int index, double[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? 0.0 : Scalars.DOUBLE.deserialize(deserialized);
        }
    }

    static final class Floats
    extends ArraySerializer<float[]> {
        static final Class<float[]> TYPE = float[].class;

        Floats() {
        }

        @Override
        protected float[] createNew(int length, Type elementType) {
            return new float[length];
        }

        @Override
        protected void forEachElement(float[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (float b : collection) {
                action.accept(Float.valueOf(b));
            }
        }

        @Override
        protected void deserializeSingle(int index, float[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? 0.0f : Scalars.FLOAT.deserialize(deserialized).floatValue();
        }
    }

    static final class Longs
    extends ArraySerializer<long[]> {
        static final Class<long[]> TYPE = long[].class;

        Longs() {
        }

        @Override
        protected long[] createNew(int length, Type elementType) {
            return new long[length];
        }

        @Override
        protected void forEachElement(long[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (long b : collection) {
                action.accept(b);
            }
        }

        @Override
        protected void deserializeSingle(int index, long[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? 0L : Scalars.LONG.deserialize(deserialized);
        }
    }

    static final class Ints
    extends ArraySerializer<int[]> {
        static final Class<int[]> TYPE = int[].class;

        Ints() {
        }

        @Override
        protected int[] createNew(int length, Type elementType) {
            return new int[length];
        }

        @Override
        protected void forEachElement(int[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (int b : collection) {
                action.accept(b);
            }
        }

        @Override
        protected void deserializeSingle(int index, int[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? 0 : Scalars.INTEGER.deserialize(deserialized);
        }
    }

    static final class Shorts
    extends ArraySerializer<short[]> {
        static final Class<short[]> TYPE = short[].class;

        Shorts() {
        }

        @Override
        protected short[] createNew(int length, Type elementType) {
            return new short[length];
        }

        @Override
        protected void forEachElement(short[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (short b : collection) {
                action.accept(b);
            }
        }

        @Override
        protected void deserializeSingle(int index, short[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? (short)0 : Scalars.INTEGER.deserialize(deserialized).shortValue();
        }
    }

    static final class Chars
    extends ArraySerializer<char[]> {
        static final Class<char[]> TYPE = char[].class;

        Chars() {
        }

        @Override
        protected char[] createNew(int length, Type elementType) {
            return new char[length];
        }

        @Override
        protected void forEachElement(char[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (char b : collection) {
                action.accept(Character.valueOf(b));
            }
        }

        @Override
        protected void deserializeSingle(int index, char[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? (char)'\u0000' : Scalars.CHAR.deserialize(deserialized).charValue();
        }
    }

    static final class Bytes
    extends ArraySerializer<byte[]> {
        static final Class<byte[]> TYPE = byte[].class;

        Bytes() {
        }

        @Override
        protected byte[] createNew(int length, Type elementType) {
            return new byte[length];
        }

        @Override
        protected void forEachElement(byte[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (byte b : collection) {
                action.accept(b);
            }
        }

        @Override
        protected void deserializeSingle(int index, byte[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? (byte)0 : Scalars.INTEGER.deserialize(deserialized).byteValue();
        }
    }

    static final class Booleans
    extends ArraySerializer<boolean[]> {
        static final Class<boolean[]> TYPE = boolean[].class;

        Booleans() {
        }

        @Override
        protected boolean[] createNew(int length, Type elementType) {
            return new boolean[length];
        }

        @Override
        protected void forEachElement(boolean[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (boolean b : collection) {
                action.accept(b);
            }
        }

        @Override
        protected void deserializeSingle(int index, boolean[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? false : Scalars.BOOLEAN.deserialize(deserialized);
        }
    }

    static final class Objects
    extends ArraySerializer<Object[]> {
        Objects() {
        }

        public static boolean accepts(Type token) {
            if (!Types.isArray(token)) {
                return false;
            }
            Type componentType = GenericTypeReflector.getArrayComponentType(token);
            return componentType.equals(GenericTypeReflector.box(componentType));
        }

        @Override
        protected Object[] createNew(int length, Type elementType) {
            return (Object[])Array.newInstance(GenericTypeReflector.erase(elementType), length);
        }

        @Override
        protected void forEachElement(Object[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (Object o : collection) {
                action.accept(o);
            }
        }

        @Override
        protected void deserializeSingle(int index, Object[] collection, @Nullable Object deserialized) {
            collection[index] = deserialized;
        }
    }
}

