/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.owasp.html;

import squaremap.libraries.org.owasp.html.AttributePolicy;
import squaremap.libraries.org.owasp.html.Strings;

final class SrcsetAttributePolicy
implements AttributePolicy {
    private final AttributePolicy srcPolicy;

    SrcsetAttributePolicy(AttributePolicy srcPolicy) {
        this.srcPolicy = srcPolicy;
    }

    @Override
    public String apply(String elementName, String attributeName, String value) {
        int i;
        StringBuilder sb = new StringBuilder();
        int n = value.length();
        for (i = 0; i < n && Strings.isHtmlSpace(value.charAt(i)); ++i) {
        }
        while (i < n) {
            int ch;
            int floatEnd;
            int urlStart = i;
            while (i < n && !Strings.isHtmlSpace(value.charAt(i))) {
                ++i;
            }
            int urlEnd = i;
            while (i < n && Strings.isHtmlSpace(value.charAt(i))) {
                ++i;
            }
            int metadataStart = i;
            if (urlEnd >= i || (floatEnd = Strings.skipValidFloatingPointNumber(value, i)) < 0 || (i = floatEnd) >= n || 97 > (ch = value.charAt(i) | 0x20) || ch <= 122) {
                // empty if block
            }
            int metadataEnd = ++i;
            if (urlStart < urlEnd) {
                if (value.charAt(urlStart) == ',' || value.charAt(urlEnd - 1) == ',') {
                    return null;
                }
                String okUrl = this.srcPolicy.apply(elementName, "src", value.substring(urlStart, urlEnd));
                if (okUrl != null && !okUrl.isEmpty()) {
                    if (sb.length() != 0) {
                        sb.append(" , ");
                    }
                    sb.append(okUrl.replace(",", "%2c"));
                    if (metadataStart < metadataEnd) {
                        sb.append(' ');
                        sb.append(value, metadataStart, metadataEnd);
                    }
                }
            }
            while (i < n && Strings.isHtmlSpace(value.charAt(i))) {
                ++i;
            }
            if (i == n || value.charAt(i) != ',') break;
            ++i;
            while (i < n && Strings.isHtmlSpace(value.charAt(i))) {
                ++i;
            }
        }
        if (i < n || sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }
}

