/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.owasp.html;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.WillCloseWhenClosed;
import squaremap.libraries.org.owasp.html.Handler;
import squaremap.libraries.org.owasp.html.HtmlStreamRenderer;

final class AutoCloseableHtmlStreamRenderer
extends HtmlStreamRenderer
implements Closeable {
    private final Object closeable;
    private static final Class<?> CLASS_AUTO_CLOSEABLE;
    private static final Method METHOD_CLOSE;
    private static final Object[] ZERO_OBJECTS;

    static boolean isAutoCloseable(Object o) {
        return o instanceof Closeable || CLASS_AUTO_CLOSEABLE != null && CLASS_AUTO_CLOSEABLE.isInstance(o);
    }

    static AutoCloseableHtmlStreamRenderer createAutoCloseableHtmlStreamRenderer(@WillCloseWhenClosed Appendable output, Handler<? super IOException> errorHandler, Handler<? super String> badHtmlHandler) {
        return new AutoCloseableHtmlStreamRenderer(output, errorHandler, badHtmlHandler);
    }

    private AutoCloseableHtmlStreamRenderer(@WillCloseWhenClosed Appendable output, Handler<? super IOException> errorHandler, Handler<? super String> badHtmlHandler) {
        super(output, errorHandler, badHtmlHandler);
        this.closeable = output;
    }

    @Override
    public void close() throws IOException {
        if (this.isDocumentOpen()) {
            this.closeDocument();
        }
        AutoCloseableHtmlStreamRenderer.closeIfAnyCloseable(this.closeable);
    }

    static void closeIfAnyCloseable(Object closeable) throws IOException {
        if (closeable instanceof Closeable) {
            ((Closeable)closeable).close();
        } else if (METHOD_CLOSE != null) {
            try {
                METHOD_CLOSE.invoke(closeable, ZERO_OBJECTS);
            }
            catch (IllegalAccessException ex) {
                AssertionError ae = new AssertionError((Object)"close not public");
                ((Throwable)((Object)ae)).initCause(ex);
                throw ae;
            }
            catch (InvocationTargetException ex) {
                Throwable tgt = ex.getTargetException();
                if (tgt instanceof IOException) {
                    throw (IOException)tgt;
                }
                if (tgt instanceof RuntimeException) {
                    throw (RuntimeException)tgt;
                }
                throw new AssertionError(null, tgt);
            }
        }
    }

    static {
        Class<?> classAutoCloseable = null;
        for (Class<?> superInterface : Closeable.class.getInterfaces()) {
            if (!"java.lang.AutoCloseable".equals(superInterface.getName())) continue;
            classAutoCloseable = superInterface;
            break;
        }
        CLASS_AUTO_CLOSEABLE = classAutoCloseable;
        Method methodClose = null;
        if (CLASS_AUTO_CLOSEABLE != null) {
            try {
                methodClose = CLASS_AUTO_CLOSEABLE.getMethod("close", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw (NoSuchMethodError)new NoSuchMethodError().initCause(ex);
            }
        }
        METHOD_CLOSE = methodClose;
        ZERO_OBJECTS = new Object[0];
    }
}

