/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.com.google.inject.spi;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Set;
import squaremap.libraries.com.google.inject.Binder;
import squaremap.libraries.com.google.inject.ConfigurationException;
import squaremap.libraries.com.google.inject.spi.Element;
import squaremap.libraries.com.google.inject.spi.ElementVisitor;
import squaremap.libraries.com.google.inject.spi.InjectionPoint;

public final class StaticInjectionRequest
implements Element {
    private final Object source;
    private final Class<?> type;

    StaticInjectionRequest(Object source, Class<?> type) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
        this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forStaticMethodsAndFields(this.type);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestStaticInjection(this.type);
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof StaticInjectionRequest && ((StaticInjectionRequest)obj).source.equals(this.source) && ((StaticInjectionRequest)obj).type.equals(this.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.source, this.type});
    }
}

