/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.com.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import squaremap.libraries.com.google.inject.Binding;
import squaremap.libraries.com.google.inject.Injector;
import squaremap.libraries.com.google.inject.Key;
import squaremap.libraries.com.google.inject.TypeLiteral;
import squaremap.libraries.com.google.inject.internal.GuiceInternal;
import squaremap.libraries.com.google.inject.internal.Messages;
import squaremap.libraries.com.google.inject.internal.SourceFormatter;
import squaremap.libraries.com.google.inject.spi.BindingSourceRestriction;

final class MissingImplementationErrorHints {
    private static final int MAX_MATCHING_TYPES_REPORTED = 3;
    private static final int MAX_RELATED_TYPES_REPORTED = 3;
    private static final ImmutableSet<Class<?>> COMMON_AMBIGUOUS_TYPES = ImmutableSet.builder().add(Object.class).add(String.class).addAll((Iterable)Primitives.allWrapperTypes()).build();

    private MissingImplementationErrorHints() {
    }

    static <T> ImmutableList<String> getSuggestions(Key<T> key, Injector injector) {
        ImmutableList.Builder suggestions = ImmutableList.builder();
        TypeLiteral<T> type = key.getTypeLiteral();
        BindingSourceRestriction.getMissingImplementationSuggestion(GuiceInternal.GUICE_INTERNAL, key).ifPresent(arg_0 -> ((ImmutableList.Builder)suggestions).add(arg_0));
        ArrayList<String> possibleMatches = new ArrayList<String>();
        List<Binding<T>> sameTypes = injector.findBindingsByType(type);
        if (!sameTypes.isEmpty()) {
            suggestions.add((Object)"%nDid you mean?");
            int howMany = Math.min(sameTypes.size(), 3);
            for (int i = 0; i < howMany; ++i) {
                suggestions.add((Object)Messages.format("%n    * %s", sameTypes.get(i).getKey()));
            }
            int remaining = sameTypes.size() - 3;
            if (remaining > 0) {
                String plural = remaining == 1 ? "" : "s";
                suggestions.add((Object)Messages.format("%n    %d more binding%s with other annotations.", remaining, plural));
            }
            suggestions.add((Object)"%n");
        } else {
            String want = type.toString();
            Map<Key<?>, Binding<?>> bindingMap = injector.getAllBindings();
            for (Key<?> bindingKey : bindingMap.keySet()) {
                String have = bindingKey.getTypeLiteral().toString();
                if (!have.contains(want) && !want.contains(have)) continue;
                Formatter fmt = new Formatter();
                fmt.format("%s bound ", Messages.convert(bindingKey));
                new SourceFormatter(bindingMap.get(bindingKey).getSource(), fmt, false).format();
                possibleMatches.add(fmt.toString());
                if (possibleMatches.size() <= 3) continue;
                break;
            }
            if (!possibleMatches.isEmpty() && possibleMatches.size() <= 3) {
                suggestions.add((Object)"%nDid you mean?");
                for (String possibleMatch : possibleMatches) {
                    suggestions.add((Object)Messages.format("%n    %s", possibleMatch));
                }
            }
        }
        if (sameTypes.isEmpty() && possibleMatches.isEmpty() && key.getAnnotationType() == null && COMMON_AMBIGUOUS_TYPES.contains(key.getTypeLiteral().getRawType())) {
            suggestions.add((Object)"%nThe key seems very generic, did you forget an annotation?");
        }
        return suggestions.build();
    }
}

