/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.types.tuples;

import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.cloud.commandframework.types.tuples.Tuple;

@API(status=API.Status.STABLE)
public class Quartet<U, V, W, X>
implements Tuple {
    private final U first;
    private final V second;
    private final W third;
    private final X fourth;

    protected Quartet(@NonNull U first, @NonNull V second, @NonNull W third, @NonNull X fourth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    public static <U, V, W, X> @NonNull Quartet<@NonNull U, @NonNull V, @NonNull W, @NonNull X> of(@NonNull U first, @NonNull V second, @NonNull W third, @NonNull X fourth) {
        return new Quartet<U, V, W, X>(first, second, third, fourth);
    }

    public final @NonNull U getFirst() {
        return this.first;
    }

    public final @NonNull V getSecond() {
        return this.second;
    }

    public final @NonNull W getThird() {
        return this.third;
    }

    public final @NonNull X getFourth() {
        return this.fourth;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quartet quartet = (Quartet)o;
        return Objects.equals(this.getFirst(), quartet.getFirst()) && Objects.equals(this.getSecond(), quartet.getSecond()) && Objects.equals(this.getThird(), quartet.getThird()) && Objects.equals(this.getFourth(), quartet.getFourth());
    }

    public final int hashCode() {
        return Objects.hash(this.getFirst(), this.getSecond(), this.getThird(), this.getFourth());
    }

    public final String toString() {
        return String.format("(%s, %s, %s, %s)", this.first, this.second, this.third, this.fourth);
    }

    @Override
    public final int getSize() {
        return 4;
    }

    @Override
    public final @NonNull Object @NonNull [] toArray() {
        Object[] array = new Object[]{this.first, this.second, this.third, this.fourth};
        return array;
    }
}

