/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.services;

import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.cloud.commandframework.services.PipelineException;
import squaremap.libraries.cloud.commandframework.services.ServiceRepository;
import squaremap.libraries.cloud.commandframework.services.types.Service;
import squaremap.libraries.io.leangen.geantyref.TypeToken;

enum ServiceFilterHandler {
    INSTANCE;


    <Context> boolean passes(@NonNull ServiceRepository.ServiceWrapper<? extends Service<Context, ?>> service, @NonNull Context context) {
        if (!service.isDefaultImplementation()) {
            for (Predicate predicate : service.getFilters()) {
                try {
                    if (predicate.test(context)) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new PipelineException(String.format("Failed to evaluate filter '%s' for '%s'", TypeToken.get(predicate.getClass()).getType().getTypeName(), service), e);
                }
            }
        }
        return true;
    }
}

