/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.cloud.commandframework.permission.CommandPermission;

@API(status=API.Status.INTERNAL, consumers={"squaremap.libraries.cloud.commandframework.*"})
public final class OrPermission
implements CommandPermission {
    private final Set<CommandPermission> permissions;

    OrPermission(@NonNull Set<CommandPermission> permissions) {
        this.permissions = Collections.unmodifiableSet(permissions);
    }

    public static @NonNull CommandPermission of(@NonNull Collection<CommandPermission> permissions) {
        HashSet<CommandPermission> objects = new HashSet<CommandPermission>();
        for (CommandPermission permission : permissions) {
            if (permission instanceof OrPermission) {
                objects.addAll(permission.getPermissions());
                continue;
            }
            objects.add(permission);
        }
        return new OrPermission(objects);
    }

    @Override
    public @NonNull Collection<@NonNull CommandPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<CommandPermission> iterator = this.permissions.iterator();
        while (iterator.hasNext()) {
            CommandPermission permission = iterator.next();
            stringBuilder.append('(').append(permission.toString()).append(')');
            if (!iterator.hasNext()) continue;
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrPermission that = (OrPermission)o;
        return this.permissions.equals(that.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.getPermissions());
    }
}

