/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.execution;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.context.CommandContext;

@FunctionalInterface
@API(status=API.Status.STABLE)
public interface CommandExecutionHandler<C> {
    @API(status=API.Status.STABLE, since="1.7.0")
    public static <C> @NonNull CommandExecutionHandler<C> noOpCommandExecutionHandler() {
        return new NullCommandExecutionHandler();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public static <C> @NonNull CommandExecutionHandler<C> delegatingExecutionHandler(List<CommandExecutionHandler<C>> handlers) {
        return new MulticastDelegateFutureCommandExecutionHandler(handlers);
    }

    public void execute(@NonNull CommandContext<C> var1);

    @API(status=API.Status.STABLE, since="1.6.0")
    default public CompletableFuture<@Nullable Void> executeFuture(@NonNull CommandContext<C> commandContext) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.execute(commandContext);
            future.complete(null);
        }
        catch (Throwable throwable) {
            future.completeExceptionally(throwable);
        }
        return future;
    }

    @API(status=API.Status.INTERNAL, consumers={"squaremap.libraries.cloud.commandframework.*"})
    public static class NullCommandExecutionHandler<C>
    implements CommandExecutionHandler<C> {
        @Override
        public void execute(@NonNull CommandContext<C> commandContext) {
        }
    }

    @API(status=API.Status.INTERNAL, consumers={"squaremap.libraries.cloud.commandframework.*"}, since="1.7.0")
    public static final class MulticastDelegateFutureCommandExecutionHandler<C>
    implements FutureCommandExecutionHandler<C> {
        private final List<CommandExecutionHandler<C>> handlers;

        private MulticastDelegateFutureCommandExecutionHandler(@NonNull List<@NonNull CommandExecutionHandler<C>> handlers) {
            this.handlers = Collections.unmodifiableList(handlers);
        }

        @Override
        public CompletableFuture<@Nullable Void> executeFuture(@NonNull CommandContext<C> commandContext) {
            @MonotonicNonNull CompletionStage<@Nullable Object> composedHandler = null;
            if (this.handlers.isEmpty()) {
                composedHandler = CompletableFuture.completedFuture(null);
            } else {
                for (CommandExecutionHandler handler : this.handlers) {
                    if (composedHandler == null) {
                        composedHandler = handler.executeFuture(commandContext);
                        continue;
                    }
                    composedHandler = composedHandler.thenCompose(ignore -> handler.executeFuture(commandContext));
                }
            }
            return composedHandler;
        }
    }

    @FunctionalInterface
    @API(status=API.Status.STABLE, since="1.6.0")
    public static interface FutureCommandExecutionHandler<C>
    extends CommandExecutionHandler<C> {
        @Override
        default public void execute(@NonNull CommandContext<C> commandContext) {
        }

        @Override
        public CompletableFuture<@Nullable Void> executeFuture(@NonNull CommandContext<C> var1);
    }
}

