/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.execution;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;
import squaremap.libraries.cloud.commandframework.Command;
import squaremap.libraries.cloud.commandframework.CommandManager;
import squaremap.libraries.cloud.commandframework.CommandTree;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.exceptions.CommandExecutionException;
import squaremap.libraries.cloud.commandframework.execution.CommandExecutionCoordinator;
import squaremap.libraries.cloud.commandframework.execution.CommandResult;
import squaremap.libraries.cloud.commandframework.services.State;
import squaremap.libraries.cloud.commandframework.types.tuples.Pair;

@API(status=API.Status.STABLE)
public final class AsynchronousCommandExecutionCoordinator<C>
extends CommandExecutionCoordinator<C> {
    private final CommandManager<C> commandManager;
    private final Executor executor;
    private final boolean synchronizeParsing;

    private AsynchronousCommandExecutionCoordinator(@Nullable Executor executor, boolean synchronizeParsing, @NonNull CommandTree<C> commandTree) {
        super(commandTree);
        this.executor = executor == null ? ForkJoinPool.commonPool() : executor;
        this.synchronizeParsing = synchronizeParsing;
        this.commandManager = commandTree.getCommandManager();
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder() {
        return new Builder();
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder() {
        return new Builder();
    }

    @Override
    public @NonNull CompletableFuture<CommandResult<C>> coordinateExecution(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> input) {
        CompletableFuture resultFuture = new CompletableFuture();
        Consumer<Command> commandConsumer = command -> {
            if (this.commandManager.postprocessContext(commandContext, (Command<C>)command) == State.ACCEPTED) {
                command.getCommandExecutionHandler().executeFuture(commandContext).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        if (throwable instanceof CommandExecutionException) {
                            resultFuture.completeExceptionally((Throwable)throwable);
                        } else {
                            resultFuture.completeExceptionally(new CommandExecutionException((Throwable)throwable, commandContext));
                        }
                    }
                    resultFuture.complete(new CommandResult(commandContext));
                });
            }
        };
        if (this.synchronizeParsing) {
            @NonNull Pair<@Nullable Command<C>, @Nullable Exception> pair = this.getCommandTree().parse(commandContext, input);
            if (pair.getSecond() != null) {
                resultFuture.completeExceptionally(pair.getSecond());
            } else {
                this.executor.execute(() -> commandConsumer.accept((Command)pair.getFirst()));
            }
        } else {
            this.executor.execute(() -> {
                try {
                    @NonNull Pair<@Nullable Command<C>, @Nullable Exception> pair = this.getCommandTree().parse(commandContext, input);
                    if (pair.getSecond() != null) {
                        resultFuture.completeExceptionally(pair.getSecond());
                    } else {
                        commandConsumer.accept(pair.getFirst());
                    }
                }
                catch (Exception e) {
                    resultFuture.completeExceptionally(e);
                }
            });
        }
        return resultFuture;
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C> {
        private Executor executor = null;
        private boolean synchronizeParsing = false;

        private Builder() {
        }

        public @NonNull @This Builder<C> withSynchronousParsing() {
            this.synchronizeParsing = true;
            return this;
        }

        public @NonNull @This Builder<C> withAsynchronousParsing() {
            this.synchronizeParsing = false;
            return this;
        }

        public @NonNull @This Builder<C> withExecutor(@NonNull Executor executor) {
            this.executor = executor;
            return this;
        }

        public @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> build() {
            return tree -> new AsynchronousCommandExecutionCoordinator(this.executor, this.synchronizeParsing, (CommandTree)tree);
        }
    }
}

