/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.exceptions.parsing;

import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.cloud.commandframework.captions.CaptionVariable;
import squaremap.libraries.cloud.commandframework.captions.StandardCaptionKeys;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.exceptions.parsing.ParserException;

@API(status=API.Status.STABLE)
public abstract class NumberParseException
extends ParserException {
    private static final long serialVersionUID = 3018775374056029797L;
    private final String input;
    private final Number min;
    private final Number max;

    protected NumberParseException(@NonNull String input, @NonNull Number min, @NonNull Number max, @NonNull Class<?> parserClass, @NonNull CommandContext<?> context) {
        super(parserClass, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_NUMBER, CaptionVariable.of("input", input), CaptionVariable.of("min", String.valueOf(min)), CaptionVariable.of("max", String.valueOf(max)));
        this.input = input;
        this.min = min;
        this.max = max;
    }

    public abstract @NonNull String getNumberType();

    public abstract boolean hasMax();

    public abstract boolean hasMin();

    public @NonNull String getInput() {
        return this.input;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }
}

