/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.bukkit;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.cloud.commandframework.CloudCapability;
import squaremap.libraries.cloud.commandframework.bukkit.internal.CraftBukkitReflection;

public enum CloudBukkitCapabilities implements CloudCapability
{
    BRIGADIER(CraftBukkitReflection.classExists("com.mojang.brigadier.tree.CommandNode") && CraftBukkitReflection.findOBCClass("command.BukkitCommandWrapper") != null),
    NATIVE_BRIGADIER(CraftBukkitReflection.classExists("com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent")),
    COMMODORE_BRIGADIER(BRIGADIER.capable() && !NATIVE_BRIGADIER.capable() && !CraftBukkitReflection.classExists("org.bukkit.entity.Warden")),
    ASYNCHRONOUS_COMPLETION(CraftBukkitReflection.classExists("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent"));

    static final Set<CloudBukkitCapabilities> CAPABLE;
    private final boolean capable;

    private CloudBukkitCapabilities(boolean capable) {
        this.capable = capable;
    }

    boolean capable() {
        return this.capable;
    }

    @Override
    public @NonNull String toString() {
        return this.name();
    }

    static {
        CAPABLE = Arrays.stream(CloudBukkitCapabilities.values()).filter(CloudBukkitCapabilities::capable).collect(Collectors.toSet());
    }
}

