/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.bukkit;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.bukkit.BukkitCommandContextKeys;
import squaremap.libraries.cloud.commandframework.bukkit.BukkitCommandManager;
import squaremap.libraries.cloud.commandframework.bukkit.CloudBukkitCapabilities;
import squaremap.libraries.cloud.commandframework.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import squaremap.libraries.cloud.commandframework.execution.preprocessor.CommandPreprocessingContext;
import squaremap.libraries.cloud.commandframework.execution.preprocessor.CommandPreprocessor;

final class BukkitCommandPreprocessor<C>
implements CommandPreprocessor<C> {
    private final BukkitCommandManager<C> commandManager;
    private final @Nullable BukkitBackwardsBrigadierSenderMapper<C, ?> mapper;

    BukkitCommandPreprocessor(@NonNull BukkitCommandManager<C> commandManager) {
        this.commandManager = commandManager;
        this.mapper = this.commandManager.hasCapability(CloudBukkitCapabilities.BRIGADIER) ? new BukkitBackwardsBrigadierSenderMapper(this.commandManager) : null;
    }

    @Override
    public void accept(@NonNull CommandPreprocessingContext<C> context) {
        if (this.mapper != null && !context.getCommandContext().contains("_cloud_brigadier_native_sender")) {
            context.getCommandContext().store("_cloud_brigadier_native_sender", this.mapper.apply(context.getCommandContext().getSender()));
        }
        context.getCommandContext().store(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER, this.commandManager.getBackwardsCommandSenderMapper().apply(context.getCommandContext().getSender()));
        context.getCommandContext().store(BukkitCommandContextKeys.CLOUD_BUKKIT_CAPABILITIES, this.commandManager.queryCapabilities());
    }
}

