/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.arguments.standard;

import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.ArgumentDescription;
import squaremap.libraries.cloud.commandframework.arguments.CommandArgument;
import squaremap.libraries.cloud.commandframework.arguments.parser.ArgumentParseResult;
import squaremap.libraries.cloud.commandframework.arguments.parser.ArgumentParser;
import squaremap.libraries.cloud.commandframework.captions.CaptionVariable;
import squaremap.libraries.cloud.commandframework.captions.StandardCaptionKeys;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import squaremap.libraries.cloud.commandframework.exceptions.parsing.ParserException;

@API(status=API.Status.STABLE)
public final class UUIDArgument<C>
extends CommandArgument<C, UUID> {
    private UUIDArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new UUIDParser(), defaultValue, UUID.class, suggestionsProvider, defaultDescription);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return UUIDArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, UUID> of(@NonNull String name) {
        return UUIDArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, UUID> optional(@NonNull String name) {
        return UUIDArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, UUID> optional(@NonNull String name, @NonNull UUID defaultUUID) {
        return UUIDArgument.builder(name).asOptionalWithDefault(defaultUUID.toString()).build();
    }

    @API(status=API.Status.STABLE)
    public static final class UUIDParser<C>
    implements ArgumentParser<C, UUID> {
        @Override
        public @NonNull ArgumentParseResult<UUID> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(UUIDParser.class, commandContext));
            }
            try {
                UUID uuid = UUID.fromString(input);
                inputQueue.remove();
                return ArgumentParseResult.success(uuid);
            }
            catch (IllegalArgumentException e) {
                return ArgumentParseResult.failure(new UUIDParseException(input, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, UUID> {
        private Builder(@NonNull String name) {
            super(UUID.class, name);
        }

        public @NonNull UUIDArgument<C> build() {
            return new UUIDArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE)
    public static final class UUIDParseException
    extends ParserException {
        private static final long serialVersionUID = 6399602590976540023L;
        private final String input;

        public UUIDParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(UUIDParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_UUID, CaptionVariable.of("input", input));
            this.input = input;
        }

        public String getInput() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UUIDParseException that = (UUIDParseException)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input);
        }
    }
}

