/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.arguments.preprocessor;

import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.cloud.commandframework.arguments.parser.ArgumentParseResult;
import squaremap.libraries.cloud.commandframework.captions.Caption;
import squaremap.libraries.cloud.commandframework.captions.CaptionVariable;
import squaremap.libraries.cloud.commandframework.captions.StandardCaptionKeys;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.exceptions.parsing.NoInputProvidedException;

@API(status=API.Status.STABLE)
public final class RegexPreprocessor<C>
implements BiFunction<CommandContext<C>, Queue<String>, ArgumentParseResult<Boolean>> {
    private final String rawPattern;
    private final Predicate<@NonNull String> predicate;
    private final Caption failureCaption;

    private RegexPreprocessor(@NonNull String pattern, @NonNull Caption failureCaption) {
        this.rawPattern = pattern;
        this.predicate = Pattern.compile(pattern).asPredicate();
        this.failureCaption = failureCaption;
    }

    public static <C> @NonNull RegexPreprocessor<C> of(@NonNull String pattern) {
        return RegexPreprocessor.of(pattern, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_REGEX);
    }

    public static <C> @NonNull RegexPreprocessor<C> of(@NonNull String pattern, @NonNull Caption failureCaption) {
        return new RegexPreprocessor<C>(pattern, failureCaption);
    }

    @Override
    public @NonNull ArgumentParseResult<Boolean> apply(@NonNull CommandContext<C> context, @NonNull Queue<@NonNull String> strings) {
        String head = strings.peek();
        if (head == null) {
            return ArgumentParseResult.failure(new NoInputProvidedException(RegexPreprocessor.class, context));
        }
        if (this.predicate.test(head)) {
            return ArgumentParseResult.success(true);
        }
        return ArgumentParseResult.failure(new RegexValidationException(this.rawPattern, head, this.failureCaption, context));
    }

    @API(status=API.Status.STABLE)
    public static final class RegexValidationException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 747826566058072233L;
        private final String pattern;
        private final String failedString;
        private final Caption failureCaption;
        private final CommandContext<?> commandContext;

        private RegexValidationException(@NonNull String pattern, @NonNull String failedString, @NonNull Caption failureCaption, @NonNull CommandContext<?> commandContext) {
            this.pattern = pattern;
            this.failedString = failedString;
            this.failureCaption = failureCaption;
            this.commandContext = commandContext;
        }

        @Override
        public String getMessage() {
            return this.commandContext.formatMessage(this.failureCaption, CaptionVariable.of("input", this.failedString), CaptionVariable.of("pattern", this.pattern));
        }

        public @NonNull String getFailedString() {
            return this.failedString;
        }

        public @NonNull String getPattern() {
            return this.pattern;
        }
    }
}

