/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.arguments;

import java.util.Iterator;
import java.util.List;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.CommandTree;
import squaremap.libraries.cloud.commandframework.arguments.CommandArgument;
import squaremap.libraries.cloud.commandframework.arguments.CommandSyntaxFormatter;
import squaremap.libraries.cloud.commandframework.arguments.StaticArgument;
import squaremap.libraries.cloud.commandframework.arguments.compound.CompoundArgument;
import squaremap.libraries.cloud.commandframework.arguments.compound.FlagArgument;
import squaremap.libraries.cloud.commandframework.arguments.flags.CommandFlag;

@API(status=API.Status.INTERNAL, consumers={"squaremap.libraries.cloud.commandframework.*"})
public class StandardCommandSyntaxFormatter<C>
implements CommandSyntaxFormatter<C> {
    @Override
    public final @NonNull String apply(@NonNull List<@NonNull CommandArgument<C, ?>> commandArguments,  @Nullable CommandTree.Node<@Nullable CommandArgument<C, ?>> node) {
        FormattingInstance formattingInstance = this.createInstance();
        Iterator<CommandArgument<C, ?>> iterator = commandArguments.iterator();
        while (iterator.hasNext()) {
            CommandArgument<C, ?> commandArgument = iterator.next();
            if (commandArgument instanceof StaticArgument) {
                formattingInstance.appendLiteral((StaticArgument)commandArgument);
            } else if (commandArgument instanceof CompoundArgument) {
                formattingInstance.appendCompound((CompoundArgument)commandArgument);
            } else if (commandArgument instanceof FlagArgument) {
                formattingInstance.appendFlag((FlagArgument)commandArgument);
            } else if (commandArgument.isRequired()) {
                formattingInstance.appendRequired(commandArgument);
            } else {
                formattingInstance.appendOptional(commandArgument);
            }
            if (!iterator.hasNext()) continue;
            formattingInstance.appendBlankSpace();
        }
        CommandTree.Node<CommandArgument<C, ?>> tail = node;
        while (tail != null && !tail.isLeaf()) {
            if (tail.getChildren().size() > 1) {
                formattingInstance.appendBlankSpace();
                Iterator<CommandTree.Node<CommandArgument<C, ?>>> childIterator = tail.getChildren().iterator();
                while (childIterator.hasNext()) {
                    CommandTree.Node<CommandArgument<C, ?>> child = childIterator.next();
                    if (child.getValue() instanceof StaticArgument) {
                        formattingInstance.appendName(child.getValue().getName());
                    } else if (child.getValue().isRequired()) {
                        formattingInstance.appendRequired(child.getValue());
                    } else {
                        formattingInstance.appendOptional(child.getValue());
                    }
                    if (!childIterator.hasNext()) continue;
                    formattingInstance.appendPipe();
                }
                break;
            }
            CommandArgument<C, ?> argument = tail.getChildren().get(0).getValue();
            if (argument instanceof CompoundArgument) {
                formattingInstance.appendBlankSpace();
                formattingInstance.appendCompound((CompoundArgument)argument);
            } else if (argument instanceof FlagArgument) {
                formattingInstance.appendBlankSpace();
                formattingInstance.appendFlag((FlagArgument)argument);
            } else if (argument instanceof StaticArgument) {
                formattingInstance.appendBlankSpace();
                formattingInstance.appendLiteral((StaticArgument)argument);
            } else {
                formattingInstance.appendBlankSpace();
                if (argument.isRequired()) {
                    formattingInstance.appendRequired(argument);
                } else {
                    formattingInstance.appendOptional(argument);
                }
            }
            tail = tail.getChildren().get(0);
        }
        return formattingInstance.toString();
    }

    protected @NonNull FormattingInstance createInstance() {
        return new FormattingInstance();
    }

    @API(status=API.Status.STABLE)
    public static class FormattingInstance {
        private final StringBuilder builder = new StringBuilder();

        protected FormattingInstance() {
        }

        public final @NonNull String toString() {
            return this.builder.toString();
        }

        public void appendLiteral(@NonNull StaticArgument<?> literal) {
            this.appendName(literal.getName());
        }

        public void appendCompound(@NonNull CompoundArgument<?, ?, ?> argument) {
            String prefix = argument.isRequired() ? this.getRequiredPrefix() : this.getOptionalPrefix();
            String suffix = argument.isRequired() ? this.getRequiredSuffix() : this.getOptionalSuffix();
            this.builder.append(prefix);
            Object[] names = argument.getNames().toArray();
            for (int i = 0; i < names.length; ++i) {
                this.builder.append(prefix);
                this.appendName(names[i].toString());
                this.builder.append(suffix);
                if (i + 1 >= names.length) continue;
                this.builder.append(' ');
            }
            this.builder.append(suffix);
        }

        public void appendFlag(@NonNull FlagArgument<?> flagArgument) {
            this.builder.append(this.getOptionalPrefix());
            Iterator<CommandFlag<?>> flagIterator = flagArgument.getFlags().iterator();
            while (flagIterator.hasNext()) {
                CommandFlag<?> flag = flagIterator.next();
                this.appendName(String.format("--%s", flag.getName()));
                if (flag.getCommandArgument() != null) {
                    this.builder.append(' ');
                    this.builder.append(this.getOptionalPrefix());
                    this.appendName(flag.getCommandArgument().getName());
                    this.builder.append(this.getOptionalSuffix());
                }
                if (!flagIterator.hasNext()) continue;
                this.appendBlankSpace();
                this.appendPipe();
                this.appendBlankSpace();
            }
            this.builder.append(this.getOptionalSuffix());
        }

        public void appendRequired(@NonNull CommandArgument<?, ?> argument) {
            this.builder.append(this.getRequiredPrefix());
            this.appendName(argument.getName());
            this.builder.append(this.getRequiredSuffix());
        }

        public void appendOptional(@NonNull CommandArgument<?, ?> argument) {
            this.builder.append(this.getOptionalPrefix());
            this.appendName(argument.getName());
            this.builder.append(this.getOptionalSuffix());
        }

        public void appendPipe() {
            this.builder.append("|");
        }

        public void appendName(@NonNull String name) {
            this.builder.append(name);
        }

        public @NonNull String getRequiredPrefix() {
            return "<";
        }

        public @NonNull String getRequiredSuffix() {
            return ">";
        }

        public @NonNull String getOptionalPrefix() {
            return "[";
        }

        public @NonNull String getOptionalSuffix() {
            return "]";
        }

        public void appendBlankSpace() {
            this.builder.append(' ');
        }
    }
}

