/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.arguments;

import java.util.List;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.cloud.commandframework.arguments.parser.ArgumentParser;
import squaremap.libraries.cloud.commandframework.context.CommandContext;

@API(status=API.Status.INTERNAL, consumers={"squaremap.libraries.cloud.commandframework.*"})
final class DelegatingSuggestionsProvider<C>
implements BiFunction<CommandContext<C>, String, List<String>> {
    private final String argumentName;
    private final ArgumentParser<C, ?> parser;

    DelegatingSuggestionsProvider(@NonNull String argumentName, @NonNull ArgumentParser<C, ?> parser) {
        this.argumentName = argumentName;
        this.parser = parser;
    }

    @Override
    public @NonNull List<@NonNull String> apply(@NonNull CommandContext<C> context, @NonNull String s) {
        return this.parser.suggestions(context, s);
    }

    public String toString() {
        return String.format("DelegatingSuggestionsProvider{name='%s',parser='%s'}", this.argumentName, this.parser.getClass().getCanonicalName());
    }
}

