/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.cloud.commandframework.annotations.injection;

import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.annotations.AnnotationAccessor;
import squaremap.libraries.cloud.commandframework.annotations.injection.InjectionService;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.types.tuples.Triplet;
import squaremap.libraries.com.google.inject.ConfigurationException;
import squaremap.libraries.com.google.inject.Injector;

@API(status=API.Status.STABLE, since="1.4.0")
public final class GuiceInjectionService<C>
implements InjectionService<C> {
    private final Injector injector;

    private GuiceInjectionService(@NonNull Injector injector) {
        this.injector = injector;
    }

    public static <C> GuiceInjectionService<C> create(@NonNull Injector injector) {
        return new GuiceInjectionService<C>(injector);
    }

    @Override
    public @Nullable Object handle(@NonNull Triplet<CommandContext<C>, Class<?>, AnnotationAccessor> triplet) {
        try {
            return this.injector.getInstance(triplet.getSecond());
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }
}

