/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.paper.util;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.entity.Player;
import xyz.jpenilla.tabtps.common.util.TPSUtil;
import xyz.jpenilla.tabtps.lib.io.papermc.lib.PaperLib;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.tabtps.paper.util.Crafty;

public final class SpigotReflection {
    private static final Class<?> MinecraftServer_class = Crafty.needNMSClassOrElse("MinecraftServer", "net.minecraft.server.MinecraftServer");
    private static final Class<?> CraftPlayer_class = Crafty.needCraftClass("entity.CraftPlayer");
    private static final Class<?> ServerPlayer_class = Crafty.needNMSClassOrElse("EntityPlayer", "net.minecraft.server.level.EntityPlayer", "net.minecraft.server.level.ServerPlayer");
    private static final MethodHandle CraftPlayer_getHandle_method = SpigotReflection.needMethod(CraftPlayer_class, "getHandle", ServerPlayer_class, new Class[0]);
    private static final MethodHandle MinecraftServer_getServer_method = SpigotReflection.needStaticMethod(MinecraftServer_class, "getServer", MinecraftServer_class, new Class[0]);
    private static final @Nullable Field ServerPlayer_latency_field = SpigotReflection.pingField();
    private static final Field MinecraftServer_recentTps_field = SpigotReflection.needField(MinecraftServer_class, "recentTps");
    private final Field MinecraftServer_recentTickTimes_field = SpigotReflection.tickTimesField();

    public static @NonNull SpigotReflection spigotReflection() {
        return Holder.INSTANCE;
    }

    private static @NonNull Field tickTimesField() {
        String tickTimes;
        int ver = PaperLib.getMinecraftVersion();
        if (ver < 13) {
            tickTimes = "h";
        } else if (ver == 13) {
            tickTimes = "d";
        } else if (ver == 14 || ver == 15) {
            tickTimes = "f";
        } else if (ver == 16) {
            tickTimes = "h";
        } else if (ver == 17) {
            tickTimes = "n";
        } else if (ver == 18) {
            tickTimes = "o";
        } else if (ver == 19 || ver == 20 && PaperLib.getMinecraftPatchVersion() < 3) {
            tickTimes = "k";
        } else if (ver == 20 && PaperLib.getMinecraftPatchVersion() < 6) {
            tickTimes = "ac";
        } else if (ver == 20 || ver == 21) {
            tickTimes = "ab";
        } else {
            throw new IllegalStateException("Don't know tickTimes field name!");
        }
        return SpigotReflection.needField(MinecraftServer_class, tickTimes);
    }

    private static @Nullable Field pingField() {
        @Nullable Field mojang = Crafty.findField(ServerPlayer_class, "latency");
        if (mojang != null) {
            return mojang;
        }
        @Nullable Field spigotNamedOld = Crafty.findField(ServerPlayer_class, "ping");
        return spigotNamedOld;
    }

    public int ping(@NonNull Player player) {
        if (ServerPlayer_latency_field == null) {
            throw new IllegalStateException("ServerPlayer_latency_field is null");
        }
        Object nmsPlayer = SpigotReflection.invokeOrThrow(CraftPlayer_getHandle_method, player);
        try {
            return ServerPlayer_latency_field.getInt(nmsPlayer);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Failed to get ping for player: '%s'", player.getName()), e);
        }
    }

    public double averageTickTime() {
        Object server = SpigotReflection.invokeOrThrow(MinecraftServer_getServer_method, new Object[0]);
        try {
            long[] recentMspt = (long[])this.MinecraftServer_recentTickTimes_field.get(server);
            return TPSUtil.toMilliseconds(TPSUtil.average(recentMspt));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to get server mspt", e);
        }
    }

    public double @NonNull [] recentTps() {
        Object server = SpigotReflection.invokeOrThrow(MinecraftServer_getServer_method, new Object[0]);
        try {
            return (double[])MinecraftServer_recentTps_field.get(server);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to get server TPS", e);
        }
    }

    private static @NonNull MethodHandle needMethod(@NonNull Class<?> holderClass, @NonNull String methodName, @NonNull Class<?> returnClass, Class<?> ... parameterClasses) {
        return Objects.requireNonNull(Crafty.findMethod(holderClass, methodName, returnClass, parameterClasses), String.format("Could not locate method '%s' in class '%s'", methodName, holderClass.getCanonicalName()));
    }

    private static @NonNull MethodHandle needStaticMethod(@NonNull Class<?> holderClass, @NonNull String methodName, @NonNull Class<?> returnClass, Class<?> ... parameterClasses) {
        return Objects.requireNonNull(Crafty.findStaticMethod(holderClass, methodName, returnClass, parameterClasses), String.format("Could not locate static method '%s' in class '%s'", methodName, holderClass.getCanonicalName()));
    }

    public static @NonNull Field needField(@NonNull Class<?> holderClass, @NonNull String fieldName) {
        try {
            Field field = holderClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(String.format("Unable to find field '%s' in class '%s'", fieldName, holderClass.getCanonicalName()), e);
        }
    }

    private static @Nullable Object invokeOrThrow(@NonNull MethodHandle methodHandle, Object ... params) {
        try {
            if (params.length == 0) {
                return methodHandle.invoke();
            }
            return methodHandle.invokeWithArguments(params);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(String.format("Unable to invoke method with args '%s'", Arrays.toString(params)), throwable);
        }
    }

    private static final class Holder {
        static final SpigotReflection INSTANCE = new SpigotReflection();

        private Holder() {
        }
    }
}

