/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.paper.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import xyz.jpenilla.tabtps.lib.org.checkerframework.common.reflection.qual.ForName;

public final class Crafty {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final String PREFIX_NMS = "net.minecraft.server";
    private static final String PREFIX_CRAFTBUKKIT = "org.bukkit.craftbukkit";
    private static final String CRAFT_SERVER = "CraftServer";
    private static final @Nullable String VERSION;

    private Crafty() {
    }

    public static @NonNull Class<?> needNMSClassOrElse(@NonNull String nms, String ... classNames) throws RuntimeException {
        Class<?> nmsClass = Crafty.findNmsClass(nms);
        if (nmsClass != null) {
            return nmsClass;
        }
        for (String name : classNames) {
            Class<?> maybe = Crafty.findClass(name);
            if (maybe == null) continue;
            return maybe;
        }
        throw new IllegalStateException(String.format("Couldn't find a class! NMS: '%s' or '%s'.", nms, Arrays.toString(classNames)));
    }

    @ForName
    public static @Nullable Class<?> findClass(@NonNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @ForName
    public static @NonNull Class<?> needCraftClass(@NonNull String className) {
        return Objects.requireNonNull(Crafty.findCraftClass(className), "Could not find org.bukkit.craftbukkit class " + className);
    }

    public static @Nullable MethodHandle findMethod(@Nullable Class<?> holderClass, String methodName, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        if (holderClass == null || returnClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        try {
            return LOOKUP.findVirtual(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static @Nullable MethodHandle findStaticMethod(@Nullable Class<?> holderClass, String methodName, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        if (holderClass == null || returnClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        try {
            return LOOKUP.findStatic(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static @NonNull Field needField(@NonNull Class<?> holderClass, @NonNull String fieldName) {
        try {
            Field field = holderClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalStateException(String.format("Unable to find field '%s' in class '%s'", fieldName, holderClass.getCanonicalName()), ex);
        }
    }

    public static @Nullable Field findField(@Nullable Class<?> holderClass, @NonNull String fieldName) {
        return Crafty.findField(holderClass, fieldName, null);
    }

    public static @Nullable Field findField(@Nullable Class<?> holderClass, @NonNull String fieldName, @Nullable Class<?> expectedType) {
        Field field;
        if (holderClass == null) {
            return null;
        }
        try {
            field = holderClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        field.setAccessible(true);
        if (expectedType != null && !expectedType.isAssignableFrom(field.getType())) {
            return null;
        }
        return field;
    }

    public static boolean isCraftBukkit() {
        return VERSION != null;
    }

    public static @Nullable String findCraftClassName(@NonNull String className) {
        return Crafty.isCraftBukkit() ? PREFIX_CRAFTBUKKIT + VERSION + className : null;
    }

    @ForName
    public static @Nullable Class<?> findCraftClass(@NonNull String className) {
        String craftClassName = Crafty.findCraftClassName(className);
        if (craftClassName == null) {
            return null;
        }
        return Crafty.findClass(craftClassName);
    }

    public static @Nullable String findNmsClassName(@NonNull String className) {
        return Crafty.isCraftBukkit() ? PREFIX_NMS + VERSION + className : null;
    }

    @ForName
    public static @Nullable Class<?> findNmsClass(@NonNull String className) {
        String nmsClassName = Crafty.findNmsClassName(className);
        if (nmsClassName == null) {
            return null;
        }
        return Crafty.findClass(nmsClassName);
    }

    static {
        Class serverClass = Bukkit.getServer().getClass();
        if (!serverClass.getSimpleName().equals(CRAFT_SERVER)) {
            VERSION = null;
        } else if (serverClass.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
            VERSION = ".";
        } else {
            String name = serverClass.getName();
            name = name.substring(PREFIX_CRAFTBUKKIT.length());
            VERSION = name = name.substring(0, name.length() - CRAFT_SERVER.length());
        }
    }
}

