/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.paper.command;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import xyz.jpenilla.tabtps.common.command.commands.TickInfoCommand;
import xyz.jpenilla.tabtps.common.util.TPSUtil;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.type.tuple.Pair;

public final class PaperTickInfoCommandFormatter
implements TickInfoCommand.Formatter {
    private final MethodHandle _getServer;
    private final MethodHandle _tickRateManager;
    private final MethodHandle _nanosecondsPerTick;
    private final MethodHandle _generateTickReport;
    private final MethodHandle _timePerTickData;
    private final MethodHandle _rawData;
    private final Pair<String, Field>[] tickTimesFields;

    public PaperTickInfoCommandFormatter() {
        try {
            Class<?> _TickData = Class.forName("ca.spottedleaf.moonrise.common.time.TickData");
            Class<?> _TickTime = Class.forName("ca.spottedleaf.moonrise.common.time.TickTime");
            Class<?> _TickReportData = Class.forName("ca.spottedleaf.moonrise.common.time.TickData$TickReportData");
            Class<?> _SegmentedAverage = Class.forName("ca.spottedleaf.moonrise.common.time.TickData$SegmentedAverage");
            Class<?> _TickRateManager = Class.forName("net.minecraft.server.ServerTickRateManager");
            Class<?> _MinecraftServer = Class.forName("net.minecraft.server.MinecraftServer");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            this._getServer = lookup.findStatic(_MinecraftServer, "getServer", MethodType.methodType(_MinecraftServer));
            this._tickRateManager = lookup.findVirtual(_MinecraftServer, "tickRateManager", MethodType.methodType(_TickRateManager));
            this._nanosecondsPerTick = lookup.findVirtual(_TickRateManager, "nanosecondsPerTick", MethodType.methodType(Long.TYPE));
            this._generateTickReport = lookup.findVirtual(_TickData, "generateTickReport", MethodType.methodType(_TickReportData, _TickTime, Long.TYPE, Long.TYPE));
            this._timePerTickData = lookup.findVirtual(_TickReportData, "timePerTickData", MethodType.methodType(_SegmentedAverage));
            this._rawData = lookup.findVirtual(_SegmentedAverage, "rawData", MethodType.methodType(long[].class));
            ArrayList<Pair<String, Field>> tickTimesFieldsList = new ArrayList<Pair<String, Field>>();
            for (Field f : _MinecraftServer.getDeclaredFields()) {
                if (f.getType() != _TickData || !f.getName().startsWith("tickTimes")) continue;
                f.setAccessible(true);
                tickTimesFieldsList.add(Pair.of(f.getName().substring("tickTimes".length()), f));
            }
            if (tickTimesFieldsList.size() < 3) {
                throw new IllegalStateException("Expected at least 3 tickTimes fields, found " + tickTimesFieldsList.size() + ": " + tickTimesFieldsList);
            }
            this.tickTimesFields = tickTimesFieldsList.toArray(new Pair[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to initialize", e);
        }
    }

    @Override
    public @NonNull List<Component> formatTickTimes() {
        try {
            Object minecraftServer = this._getServer.invoke();
            Object tickRateManager = this._tickRateManager.invoke(minecraftServer);
            long nanosecondsPerTick = this._nanosecondsPerTick.invoke(tickRateManager);
            long now = System.nanoTime();
            ArrayList<Pair<String, long[]>> formatList = new ArrayList<Pair<String, long[]>>();
            for (Pair<String, Field> pair : this.tickTimesFields) {
                Object tickData = pair.second().get(minecraftServer);
                if (tickData == null) {
                    throw new IllegalStateException("TickData field " + pair.first() + " was null");
                }
                long[] rawData = this.extractRawData(tickData, now, nanosecondsPerTick);
                formatList.add(Pair.of(pair.first(), rawData));
            }
            return TPSUtil.formatTickTimes(formatList);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to retrieve tick time statistics", throwable);
        }
    }

    private long[] extractRawData(Object tickData, long now, long nanosecondsPerTick) throws Throwable {
        Object reportData = this._generateTickReport.invoke(tickData, null, now, nanosecondsPerTick);
        if (reportData == null) {
            return new long[0];
        }
        Object timePerTickData = this._timePerTickData.invoke(reportData);
        return this._rawData.invoke(timePerTickData);
    }
}

