/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.paper.command;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import xyz.jpenilla.tabtps.common.command.commands.TickInfoCommand;
import xyz.jpenilla.tabtps.common.util.TPSUtil;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.type.tuple.Pair;
import xyz.jpenilla.tabtps.paper.util.Crafty;

public final class LegacyPaperTickInfoCommandFormatter
implements TickInfoCommand.Formatter {
    private final Class<?> _MinecraftServer = Crafty.needNMSClassOrElse("MinecraftServer", "net.minecraft.server.MinecraftServer");
    private final Class<?> _MinecraftServer_TickTimes = Crafty.needNMSClassOrElse("MinecraftServer$TickTimes", "net.minecraft.server.MinecraftServer$TickTimes");
    private final MethodHandle _getServer = Objects.requireNonNull(Crafty.findStaticMethod(this._MinecraftServer, "getServer", this._MinecraftServer, new Class[0]));
    private final MethodHandle _getTimes = Objects.requireNonNull(Crafty.findMethod(this._MinecraftServer_TickTimes, "getTimes", long[].class, new Class[0]));
    private final Field _tickTimes5s = Crafty.needField(this._MinecraftServer, "tickTimes5s");
    private final Field _tickTimes10s = Crafty.needField(this._MinecraftServer, "tickTimes10s");
    private final Field _tickTimes60s = Crafty.needField(this._MinecraftServer, "tickTimes60s");

    @Override
    public @NonNull List<Component> formatTickTimes() {
        try {
            Object minecraftServer = this._getServer.invoke();
            Object tickTimes5s = this._tickTimes5s.get(minecraftServer);
            Object tickTimes10s = this._tickTimes10s.get(minecraftServer);
            Object tickTimes60s = this._tickTimes60s.get(minecraftServer);
            long[] times5s = this._getTimes.bindTo(tickTimes5s).invoke();
            long[] times10s = this._getTimes.bindTo(tickTimes10s).invoke();
            long[] times60s = this._getTimes.bindTo(tickTimes60s).invoke();
            return TPSUtil.formatTickTimes((List<Pair<String, long[]>>)ImmutableList.of(Pair.of("5s", times5s), Pair.of("10s", times10s), Pair.of("60s", times60s)));
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to retrieve tick time statistics", throwable);
        }
    }
}

