/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.paper;

import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.TabTPSPlatform;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.commands.TickInfoCommand;
import xyz.jpenilla.tabtps.common.service.TickTimeService;
import xyz.jpenilla.tabtps.common.service.UserService;
import xyz.jpenilla.tabtps.common.util.UpdateChecker;
import xyz.jpenilla.tabtps.lib.io.papermc.lib.PaperLib;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import xyz.jpenilla.tabtps.lib.org.bstats.bukkit.Metrics;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.CommandManager;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.SenderMapper;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.execution.ExecutionCoordinator;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.paper.LegacyPaperCommandManager;
import xyz.jpenilla.tabtps.lib.org.slf4j.Logger;
import xyz.jpenilla.tabtps.lib.org.slf4j.LoggerFactory;
import xyz.jpenilla.tabtps.paper.BukkitUser;
import xyz.jpenilla.tabtps.paper.JoinQuitListener;
import xyz.jpenilla.tabtps.paper.command.BukkitConsoleCommander;
import xyz.jpenilla.tabtps.paper.command.BukkitPingCommand;
import xyz.jpenilla.tabtps.paper.command.LegacyPaperTickInfoCommandFormatter;
import xyz.jpenilla.tabtps.paper.command.PaperTickInfoCommandFormatter;
import xyz.jpenilla.tabtps.paper.service.BukkitUserService;
import xyz.jpenilla.tabtps.paper.service.PaperTickTimeService;
import xyz.jpenilla.tabtps.paper.service.SpigotTickTimeService;

public final class TabTPSPlugin
extends JavaPlugin
implements TabTPSPlatform<Player, BukkitUser> {
    private TabTPS tabTPS;
    private LegacyPaperCommandManager<Commander> commandManager;
    private UserService<Player, BukkitUser> userService;
    private TickTimeService tickTimeService;
    private Logger logger;
    private BukkitAudiences audiences;

    public void onEnable() {
        PaperLib.suggestPaper((Plugin)this, Level.WARNING);
        this.logger = LoggerFactory.getLogger(this.getLogger().getName());
        if (this.craftBukkit()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.tickTimeService = PaperLib.getMinecraftVersion() < 16 || !PaperLib.isPaper() ? new SpigotTickTimeService() : new PaperTickTimeService();
        this.setupCommandManager();
        this.userService = new BukkitUserService(this);
        this.tabTPS = new TabTPS(this);
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new JoinQuitListener(this), (Plugin)this);
        if (this.tabTPS.configManager().pluginSettings().updateChecker()) {
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> UpdateChecker.checkVersion(this.getDescription().getVersion()).forEach(this.logger::info));
        }
        Metrics metrics = new Metrics((Plugin)this, 8458);
    }

    public void onDisable() {
        if (this.tabTPS != null) {
            this.tabTPS.shutdown();
        }
        if (this.audiences != null) {
            this.audiences.close();
            this.audiences = null;
        }
    }

    @Override
    public void shutdown() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    @Override
    public void onReload() {
        if (PaperLib.getMinecraftVersion() >= 13) {
            this.getServer().getOnlinePlayers().forEach(Player::updateCommands);
        }
    }

    public BukkitAudiences audiences() {
        return Objects.requireNonNull(this.audiences, "BukkitAudiences");
    }

    private void setupCommandManager() {
        this.commandManager = new LegacyPaperCommandManager<Commander>((Plugin)this, ExecutionCoordinator.simpleCoordinator(), SenderMapper.create(commandSender -> {
            if (commandSender instanceof Player) {
                return this.userService().user((Player)commandSender);
            }
            return BukkitConsoleCommander.from(this.audiences, commandSender);
        }, commander -> {
            if (commander instanceof BukkitConsoleCommander) {
                return ((BukkitConsoleCommander)commander).commandSender();
            }
            if (commander instanceof BukkitUser) {
                return (CommandSender)((BukkitUser)commander).base();
            }
            throw new IllegalArgumentException();
        }));
        if (this.commandManager.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            this.commandManager.registerBrigadier();
        } else if (this.commandManager.hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            this.commandManager.registerAsynchronousCompletions();
        }
    }

    private static boolean hasCopperGolem() {
        try {
            Class.forName("org.bukkit.entity.CopperGolem");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void registerCommands() {
        if (PaperLib.getMinecraftVersion() >= 15 && PaperLib.isPaper()) {
            if (TabTPSPlugin.hasCopperGolem()) {
                TickInfoCommand.withFormatter(this.tabTPS, this.tabTPS.commands(), new PaperTickInfoCommandFormatter()).register();
            } else {
                TickInfoCommand.withFormatter(this.tabTPS, this.tabTPS.commands(), new LegacyPaperTickInfoCommandFormatter()).register();
            }
        } else {
            TickInfoCommand.defaultFormatter(this.tabTPS, this.tabTPS.commands()).register();
        }
        new BukkitPingCommand(this, this.tabTPS.commands()).register();
    }

    @Override
    public @NonNull CommandManager<Commander> commandManager() {
        return this.commandManager;
    }

    @Override
    public @NonNull UserService<Player, BukkitUser> userService() {
        return this.userService;
    }

    @Override
    public @NonNull Path dataDirectory() {
        return this.getDataFolder().toPath();
    }

    @Override
    public @NonNull TabTPS tabTPS() {
        return this.tabTPS;
    }

    @Override
    public @NonNull TickTimeService tickTimeService() {
        return this.tickTimeService;
    }

    @Override
    public int maxPlayers() {
        return this.getServer().getMaxPlayers();
    }

    @Override
    public @NonNull Logger logger() {
        return this.logger;
    }

    private boolean craftBukkit() {
        if (!PaperLib.isSpigot()) {
            this.logger.error("==========================================");
            this.logger.error("TabTPS is not compatible with CraftBukkit.");
            this.logger.error("You must use either Spigot or later forks");
            this.logger.error("such as Paper in order to use TabTPS.");
            this.logger.error("==========================================");
            return true;
        }
        return false;
    }
}

