/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.reactive;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.reactive.CachedPublisher;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.reactive.Disposable;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.reactive.ExecutePublisher;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.reactive.MappedProcessor;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.reactive.Subscriber;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.reactive.TransactionFailedException;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.util.CheckedFunction;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.util.CheckedSupplier;

public interface Publisher<V> {
    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action) {
        return Publisher.execute(action, ForkJoinPool.commonPool());
    }

    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action, Executor executor) {
        return new ExecutePublisher<V>(Objects.requireNonNull(action, "action"), Objects.requireNonNull(executor, "executor"));
    }

    public Disposable subscribe(Subscriber<? super V> var1);

    public boolean hasSubscribers();

    default public <R> Publisher<R> map(CheckedFunction<? super V, ? extends R, TransactionFailedException> mapper) {
        return new MappedProcessor<V, R>(mapper, this);
    }

    default public Cached<V> cache() {
        return this.cache(null);
    }

    default public Cached<V> cache(@Nullable V initialValue) {
        return new CachedPublisher<V>(this, initialValue);
    }

    public Executor executor();

    public static interface Cached<V>
    extends Publisher<V> {
        public V get();

        public void submit(V var1);
    }
}

