/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.standard;

import org.apiguardian.api.API;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.component.CommandComponent;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandInput;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.exception.parsing.NumberParseException;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.ArgumentParseResult;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.ParserDescriptor;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.standard.IntegerParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.standard.NumberParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.type.range.Range;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.type.range.ShortRange;

@API(status=API.Status.STABLE)
public final class ShortParser<C>
extends NumberParser<C, Short, ShortRange>
implements BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE)
    public static final short DEFAULT_MINIMUM = Short.MIN_VALUE;
    @API(status=API.Status.STABLE)
    public static final short DEFAULT_MAXIMUM = Short.MAX_VALUE;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Short> shortParser() {
        return ShortParser.shortParser((short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Short> shortParser(short minValue) {
        return ParserDescriptor.of(new ShortParser<C>(minValue, Short.MAX_VALUE), Short.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Short> shortParser(short minValue, short maxValue) {
        return ParserDescriptor.of(new ShortParser<C>(minValue, maxValue), Short.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Short> shortComponent() {
        return CommandComponent.builder().parser(ShortParser.shortParser());
    }

    public ShortParser(short min, short max) {
        super(Range.shortRange(min, max));
    }

    @Override
    public @NonNull ArgumentParseResult<Short> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidShort((ShortRange)this.range())) {
            return ArgumentParseResult.failure(new ShortParseException(commandInput.peekString(), this, commandContext));
        }
        return ArgumentParseResult.success(commandInput.readShort());
    }

    @Override
    public boolean hasMax() {
        return ((ShortRange)this.range()).maxShort() != Short.MAX_VALUE;
    }

    @Override
    public boolean hasMin() {
        return ((ShortRange)this.range()).minShort() != Short.MIN_VALUE;
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return IntegerParser.getSuggestions(this.range(), input);
    }

    @API(status=API.Status.STABLE)
    public static final class ShortParseException
    extends NumberParseException {
        @API(status=API.Status.STABLE)
        public ShortParseException(@NonNull String input, @NonNull ShortParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, parser, commandContext);
        }

        @Override
        public @NonNull String numberType() {
            return "short";
        }
    }
}

