/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.standard;

import java.time.Duration;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.caption.CaptionVariable;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.caption.StandardCaptionKeys;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.component.CommandComponent;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandInput;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.exception.parsing.ParserException;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.ArgumentParseResult;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.ArgumentParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.ParserDescriptor;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.suggestion.BlockingSuggestionProvider;

@API(status=API.Status.STABLE)
public final class DurationParser<C>
implements ArgumentParser<C, Duration>,
BlockingSuggestionProvider.Strings<C> {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(([1-9][0-9]+|[1-9])[dhms])");

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Duration> durationParser() {
        return ParserDescriptor.of(new DurationParser<C>(), Duration.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Duration> durationComponent() {
        return CommandComponent.builder().parser(DurationParser.durationParser());
    }

    @Override
    public @NonNull ArgumentParseResult<Duration> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        Matcher matcher = DURATION_PATTERN.matcher(input);
        Duration duration = Duration.ofNanos(0L);
        block12: while (matcher.find()) {
            String group = matcher.group();
            String timeUnit = String.valueOf(group.charAt(group.length() - 1));
            int timeValue = Integer.parseInt(group.substring(0, group.length() - 1));
            switch (timeUnit) {
                case "d": {
                    duration = duration.plusDays(timeValue);
                    continue block12;
                }
                case "h": {
                    duration = duration.plusHours(timeValue);
                    continue block12;
                }
                case "m": {
                    duration = duration.plusMinutes(timeValue);
                    continue block12;
                }
                case "s": {
                    duration = duration.plusSeconds(timeValue);
                    continue block12;
                }
            }
            return ArgumentParseResult.failure(new DurationParseException(input, commandContext));
        }
        if (duration.isZero()) {
            return ArgumentParseResult.failure(new DurationParseException(input, commandContext));
        }
        return ArgumentParseResult.success(duration);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        if (input.isEmpty(true)) {
            return IntStream.range(1, 10).boxed().sorted().map(String::valueOf).collect(Collectors.toList());
        }
        if (Character.isLetter(input.lastRemainingCharacter())) {
            return Collections.emptyList();
        }
        String string = input.readString();
        return Stream.of("d", "h", "m", "s").filter(unit -> !string.contains((CharSequence)unit)).map(unit -> string + unit).collect(Collectors.toList());
    }

    @API(status=API.Status.STABLE)
    public static final class DurationParseException
    extends ParserException {
        private final String input;

        public DurationParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(DurationParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_DURATION, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

