/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.org.incendo.cloud.paper.suggestion;

import org.apiguardian.api.API;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.paper.LegacyPaperCommandManager;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.paper.suggestion.AsyncCommandSuggestionListener;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.paper.suggestion.BrigadierAsyncCommandSuggestionListener;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.paper.suggestion.SuggestionListener;

@API(status=API.Status.INTERNAL, since="2.0.0")
public interface SuggestionListenerFactory<C> {
    public static <C> @NonNull SuggestionListenerFactory<C> create(@NonNull LegacyPaperCommandManager<C> commandManager) {
        return new SuggestionListenerFactoryImpl(commandManager);
    }

    public @NonNull SuggestionListener<C> createListener();

    public static final class SuggestionListenerFactoryImpl<C>
    implements SuggestionListenerFactory<C> {
        private final LegacyPaperCommandManager<C> commandManager;

        private SuggestionListenerFactoryImpl(@NonNull LegacyPaperCommandManager<C> commandManager) {
            this.commandManager = commandManager;
        }

        @Override
        public @NonNull SuggestionListener<C> createListener() {
            @Nullable Class<?> completionCls = CraftBukkitReflection.findClass("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent$Completion");
            if (completionCls != null) {
                return new BrigadierAsyncCommandSuggestionListener<C>(this.commandManager);
            }
            return new AsyncCommandSuggestionListener<C>(this.commandManager);
        }
    }
}

