/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.org.incendo.cloud.minecraft.extras.caption;

import java.util.List;
import org.apiguardian.api.API;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.minimessage.MiniMessage;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.caption.Caption;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.caption.CaptionVariable;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.minecraft.extras.caption.RichVariable;

@API(status=API.Status.INTERNAL)
final class MiniMessageComponentCaptionFormatter<C>
implements ComponentCaptionFormatter<C> {
    private final MiniMessage miniMessage;
    private final List<TagResolver> extraResolvers;

    MiniMessageComponentCaptionFormatter(@NonNull MiniMessage miniMessage, @NonNull List<TagResolver> extraResolvers) {
        this.miniMessage = miniMessage;
        this.extraResolvers = extraResolvers;
    }

    @Override
    public @NonNull Component formatCaption(@NonNull Caption captionKey, @NonNull C recipient, @NonNull String caption, @NonNull List<@NonNull CaptionVariable> variables) {
        TagResolver.Builder builder = TagResolver.builder();
        builder.resolvers(this.extraResolvers);
        for (CaptionVariable variable : variables) {
            String key = variable.key();
            if (variable instanceof RichVariable) {
                builder.resolver(Placeholder.component(key, ((RichVariable)variable).component()));
                continue;
            }
            builder.resolver(Placeholder.parsed(key, variable.value()));
        }
        return this.miniMessage.deserialize(caption, builder.build());
    }
}

