/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.org.incendo.cloud.injection;

import java.util.Objects;
import org.apiguardian.api.API;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.util.annotation.AnnotationAccessor;

@FunctionalInterface
@API(status=API.Status.STABLE)
public interface ParameterInjector<C, T> {
    @API(status=API.Status.STABLE)
    public static <C, T> @NonNull ParameterInjector<C, T> constantInjector(@NonNull T value) {
        return new ConstantInjector(value);
    }

    public @Nullable T create(@NonNull CommandContext<C> var1, @NonNull AnnotationAccessor var2);

    public static final class ConstantInjector<C, T>
    implements ParameterInjector<C, T> {
        private final T value;

        private ConstantInjector(@NonNull T value) {
            this.value = value;
        }

        @Override
        public @NonNull T create(@NonNull CommandContext<C> context, @NonNull AnnotationAccessor annotationAccessor) {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstantInjector that = (ConstantInjector)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ConstantInjector{value=" + this.value + '}';
        }
    }
}

