/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.org.incendo.cloud.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apiguardian.api.API;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.execution.CommandExecutionHandler;

@API(status=API.Status.INTERNAL)
final class MulticastDelegateFutureCommandExecutionHandler<C>
implements CommandExecutionHandler.FutureCommandExecutionHandler<C> {
    private final List<CommandExecutionHandler<C>> handlers;

    MulticastDelegateFutureCommandExecutionHandler(@NonNull List<@NonNull CommandExecutionHandler<C>> handlers) {
        ArrayList<CommandExecutionHandler<C>> unwrappedHandlers = new ArrayList<CommandExecutionHandler<C>>();
        for (CommandExecutionHandler<C> handler : handlers) {
            if (handler instanceof MulticastDelegateFutureCommandExecutionHandler) {
                unwrappedHandlers.addAll(((MulticastDelegateFutureCommandExecutionHandler)handler).handlers);
                continue;
            }
            unwrappedHandlers.add(handler);
        }
        this.handlers = Collections.unmodifiableList(unwrappedHandlers);
    }

    @Override
    public CompletableFuture<@Nullable Void> executeFuture(@NonNull CommandContext<C> commandContext) {
        @MonotonicNonNull CompletionStage<@Nullable Object> composedHandler = null;
        if (this.handlers.isEmpty()) {
            composedHandler = CompletableFuture.completedFuture(null);
        } else {
            for (CommandExecutionHandler handler : this.handlers) {
                if (composedHandler == null) {
                    composedHandler = handler.executeFuture(commandContext);
                    continue;
                }
                composedHandler = composedHandler.thenCompose(ignore -> handler.executeFuture(commandContext));
            }
        }
        return composedHandler;
    }
}

