/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit;

import java.lang.reflect.Method;
import org.apiguardian.api.API;
import xyz.jpenilla.tabtps.lib.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.CommandManager;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.BukkitParserParameters;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.annotation.specifier.DefaultNamespace;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.data.MultipleEntitySelector;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.data.MultiplePlayerSelector;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.BlockPredicateParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.EnchantmentParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.ItemStackParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.ItemStackPredicateParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.MaterialParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.NamespacedKeyParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.OfflinePlayerParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.PlayerParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.WorldParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.location.Location2DParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.location.LocationParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.ParserParameters;

@API(status=API.Status.INTERNAL)
public final class BukkitParsers {
    private BukkitParsers() {
    }

    public static <C> void register(CommandManager<C> manager) {
        manager.parserRegistry().registerParser(WorldParser.worldParser()).registerParser(MaterialParser.materialParser()).registerParser(PlayerParser.playerParser()).registerParser(OfflinePlayerParser.offlinePlayerParser()).registerParser(EnchantmentParser.enchantmentParser()).registerParser(LocationParser.locationParser()).registerParser(Location2DParser.location2DParser()).registerParser(ItemStackParser.itemStackParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
        manager.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, annotation.value()));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            BukkitParsers.registerParserSupplierFor(manager, NamespacedKeyParser.class);
            manager.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, true));
            manager.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, annotation.value()));
        }
        if (manager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            BukkitParsers.registerParserSupplierFor(manager, ItemStackPredicateParser.class);
            BukkitParsers.registerParserSupplierFor(manager, BlockPredicateParser.class);
        }
    }

    private static void registerParserSupplierFor(CommandManager<?> manager, @NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", CommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

