/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.tabtps.lib.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.key.Key;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.serializer.configurate4.KeySerializer;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.BlockNBTComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.BuildableComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.EntityNBTComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.KeybindComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.NBTComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.NBTComponentBuilder;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.ObjectComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.ScoreComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.SelectorComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.StorageNBTComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TextComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TranslatableComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TranslationArgument;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.Style;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.object.ObjectContents;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.object.PlayerHeadObjectContents;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.object.SpriteObjectContents;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.serializer.ComponentSerializer;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.util.Buildable;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.ConfigurationNode;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.serialize.TypeSerializer;

final class ComponentTypeSerializer
implements TypeSerializer<Component> {
    static final TypeToken<List<Component>> LIST_TYPE = new TypeToken<List<Component>>(){};
    static final TypeToken<List<PlayerHeadObjectContents.ProfileProperty>> PROPERTY_LIST_TYPE = new TypeToken<List<PlayerHeadObjectContents.ProfileProperty>>(){};
    @Nullable
    private final ComponentSerializer<Component, ? extends Component, String> stringSerial;
    private final boolean preferString;

    ComponentTypeSerializer(@Nullable ComponentSerializer<Component, ? extends Component, String> stringSerial, boolean preferString) {
        this.stringSerial = stringSerial;
        this.preferString = preferString;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        return this.deserialize0(value);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private BuildableComponent<?, ?> deserialize0(@NotNull ConfigurationNode value) throws SerializationException {
        Style style;
        void var2_19;
        Map<Object, ? extends ConfigurationNode> children;
        if (!value.isList() && !value.isMap()) {
            String string = value.getString();
            if (string != null) {
                if (this.stringSerial == null) return Component.text(string);
                Component ret = this.stringSerial.deserialize(string);
                if (ret instanceof BuildableComponent) return (BuildableComponent)ret;
                throw new SerializationException("Result " + ret + " is not builable");
            }
        } else {
            if (value.isList()) {
                void var2_4;
                Object var2_3 = null;
                for (ConfigurationNode configurationNode : value.childrenList()) {
                    BuildableComponent<?, ?> child = this.deserialize0(configurationNode);
                    if (var2_4 == null) {
                        Buildable.Builder builder = child.toBuilder();
                        continue;
                    }
                    var2_4.append((Component)child);
                }
                if (var2_4 != null) return var2_4.build();
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
            if (!value.isMap()) {
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
        }
        if ((children = value.childrenMap()).containsKey("text")) {
            TextComponent.Builder builder = Component.text().content(children.get("text").getString());
        } else if (children.containsKey("translate")) {
            TranslatableComponent.Builder builder = Component.translatable().key(children.get("translate").getString());
            if (children.containsKey("with")) {
                ConfigurationNode with = children.get("with");
                if (!with.isList()) {
                    throw new SerializationException("Expected with to be a list");
                }
                List<TranslationArgument> list = with.getList(TranslationArgument.class);
                builder.arguments(list);
            }
            if (children.containsKey("fallback")) {
                builder.fallback(children.get("fallback").getString());
            }
            TranslatableComponent.Builder builder2 = builder;
        } else if (children.containsKey("score")) {
            ConfigurationNode configurationNode = children.get("score");
            ConfigurationNode name = configurationNode.node("name");
            ConfigurationNode configurationNode2 = configurationNode.node("objective");
            if (name.virtual() || configurationNode2.virtual()) {
                throw new SerializationException("A score component requires a name and objective");
            }
            ScoreComponent.Builder builder = Component.score().name(name.getString()).objective(configurationNode2.getString());
            ConfigurationNode scoreValue = configurationNode.node("value");
            if (!scoreValue.virtual()) {
                ScoreComponent.Builder builder3 = builder.value(scoreValue.getString());
            } else {
                ScoreComponent.Builder builder4 = builder;
            }
        } else if (children.containsKey("selector")) {
            SelectorComponent.Builder builder = Component.selector().pattern(children.get("selector").getString());
        } else if (children.containsKey("keybind")) {
            KeybindComponent.Builder builder = Component.keybind().keybind(children.get("keybind").getString());
        } else if (children.containsKey("nbt")) {
            boolean interpret;
            String string = children.get("nbt").getString();
            boolean bl = interpret = children.containsKey("interpret") && children.get("interpret").getBoolean();
            if (children.containsKey("block")) {
                BlockNBTComponent.Pos pos = (BlockNBTComponent.Pos)children.get("block").get(BlockNBTPosSerializer.INSTANCE.type());
                BlockNBTComponent.Builder builder = ComponentTypeSerializer.nbt(Component.blockNBT(), string, interpret).pos(pos);
            } else if (children.containsKey("entity")) {
                EntityNBTComponent.Builder builder = ComponentTypeSerializer.nbt(Component.entityNBT(), string, interpret).selector(children.get("entity").getString());
            } else {
                if (!children.containsKey("storage")) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
                StorageNBTComponent.Builder builder = ComponentTypeSerializer.nbt(Component.storageNBT(), string, interpret).storage((Key)children.get("storage").get(KeySerializer.INSTANCE.type()));
            }
        } else if (children.containsKey("sprite")) {
            ObjectComponent.Builder builder = Component.object().contents(ObjectContents.sprite(children.containsKey("atlas") ? (Key)children.get("atlas").get(KeySerializer.INSTANCE.type()) : SpriteObjectContents.DEFAULT_ATLAS, (Key)children.get("sprite").get(KeySerializer.INSTANCE.type())));
        } else {
            ConfigurationNode player;
            if (!children.containsKey("player")) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            PlayerHeadObjectContents.Builder builder = ObjectContents.playerHead();
            if (children.containsKey("hat")) {
                builder.hat(children.get("hat").getBoolean());
            }
            if ((player = children.get("player")).isMap()) {
                Map<Object, ? extends ConfigurationNode> map = player.childrenMap();
                if (map.containsKey("name")) {
                    builder.name(map.get("name").getString());
                }
                if (map.containsKey("id")) {
                    builder.id(map.get("id").get(UUID.class));
                }
                if (map.containsKey("properties")) {
                    ConfigurationNode properties = map.get("properties");
                    if (properties.isList()) {
                        builder.profileProperties((Collection<PlayerHeadObjectContents.ProfileProperty>)properties.get(PROPERTY_LIST_TYPE));
                    } else if (properties.isMap()) {
                        Map<Object, ? extends ConfigurationNode> propertyMap = properties.childrenMap();
                        for (Map.Entry<Object, ? extends ConfigurationNode> entry : propertyMap.entrySet()) {
                            for (ConfigurationNode configurationNode : entry.getValue().childrenList()) {
                                builder.profileProperty(PlayerHeadObjectContents.property(entry.getKey().toString(), configurationNode.getString()));
                            }
                        }
                    }
                }
                if (map.containsKey("texture")) {
                    builder.texture((Key)map.get("texture").get(KeySerializer.INSTANCE.type()));
                }
            } else {
                if (player.isList()) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
                builder.name(player.getString());
            }
            ObjectComponent.Builder builder5 = Component.object().contents(builder.build());
        }
        if (children.containsKey("extra")) {
            ConfigurationNode configurationNode = children.get("extra");
            for (ConfigurationNode configurationNode3 : configurationNode.childrenList()) {
                var2_19.append((Component)this.deserialize0(configurationNode3));
            }
        }
        if ((style = value.get(Style.class, Style.empty())).isEmpty()) return var2_19.build();
        var2_19.style(style);
        return var2_19.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void serialize(@NotNull Type type, @Nullable Component src, @NotNull ConfigurationNode value) throws SerializationException {
        value.set(null);
        if (src == null) {
            return;
        }
        if (this.stringSerial != null && this.preferString) {
            try {
                value.set(this.stringSerial.serialize(src));
                return;
            }
            catch (Exception ex) {
                throw new SerializationException(ex);
            }
        }
        if (src instanceof TextComponent) {
            value.node("text").set(((TextComponent)src).content());
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            value.node("translate").set(tc.key());
            if (!tc.arguments().isEmpty()) {
                ConfigurationNode with = value.node("with");
                for (TranslationArgument arg : tc.arguments()) {
                    with.appendListNode().set(TranslationArgument.class, arg);
                }
            }
            value.node("fallback").set(tc.fallback());
        } else if (src instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)src;
            ConfigurationNode score = value.node("score");
            score.node("name").set(sc.name());
            score.node("objective").set(sc.objective());
            @Nullable String scoreValue = sc.value();
            if (scoreValue != null) {
                score.node("value").set(scoreValue);
            }
        } else if (src instanceof SelectorComponent) {
            value.node("selector").set(((SelectorComponent)src).pattern());
        } else if (src instanceof KeybindComponent) {
            value.node("keybind").set(((KeybindComponent)src).keybind());
        } else if (src instanceof NBTComponent) {
            NBTComponent nc = (NBTComponent)src;
            value.node("nbt").set(nc.nbtPath());
            value.node("interpret").set(nc.interpret());
            if (src instanceof BlockNBTComponent) {
                value.node("block").set(BlockNBTPosSerializer.INSTANCE.type(), ((BlockNBTComponent)nc).pos());
            } else if (src instanceof EntityNBTComponent) {
                value.node("entity").set(((EntityNBTComponent)nc).selector());
            } else {
                if (!(src instanceof StorageNBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
                value.node("storage").set(KeySerializer.INSTANCE.type(), ((StorageNBTComponent)nc).storage());
            }
        } else {
            if (!(src instanceof ObjectComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
            ObjectComponent objectComponent = (ObjectComponent)src;
            ObjectContents contents = objectComponent.contents();
            if (contents instanceof SpriteObjectContents) {
                SpriteObjectContents spriteContents = (SpriteObjectContents)contents;
                if (!spriteContents.atlas().equals(SpriteObjectContents.DEFAULT_ATLAS)) {
                    value.node("atlas").set(KeySerializer.INSTANCE.type(), spriteContents.atlas());
                }
                value.node("sprite").set(KeySerializer.INSTANCE.type(), spriteContents.sprite());
            } else {
                if (!(contents instanceof PlayerHeadObjectContents)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
                PlayerHeadObjectContents playerHeadContents = (PlayerHeadObjectContents)contents;
                value.node("hat").set(playerHeadContents.hat());
                String playerName = playerHeadContents.name();
                UUID playerId = playerHeadContents.id();
                List<PlayerHeadObjectContents.ProfileProperty> properties = playerHeadContents.profileProperties();
                Key texture = playerHeadContents.texture();
                ConfigurationNode player = value.node("player");
                if (playerId == null && properties.isEmpty() && texture == null) {
                    if (playerName != null) {
                        player.set(playerName);
                    } else {
                        player.set(Collections.emptyMap());
                    }
                } else {
                    if (playerName != null) {
                        player.node("name").set(playerName);
                    }
                    if (playerId != null) {
                        player.node("id").set(playerId);
                    }
                    if (!properties.isEmpty()) {
                        player.node("properties").set(PROPERTY_LIST_TYPE, properties);
                    }
                    if (texture != null) {
                        player.node("texture").set(KeySerializer.INSTANCE.type(), texture);
                    }
                }
            }
        }
        List<Component> children = src.children();
        if (!children.isEmpty()) {
            value.node("extra").set(LIST_TYPE, children);
        }
        if (!src.hasStyling()) return;
        value.set(Style.class, src.style());
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, String nbt, boolean interpret) {
        return builder.nbtPath(nbt).interpret(interpret);
    }

    private static SerializationException notSureHowToDeserialize(ConfigurationNode element) {
        return new SerializationException("Don't know how to turn " + element + " into a Component");
    }

    private static SerializationException notSureHowToSerialize(Component component) {
        return new SerializationException("Don't know how to serialize " + component + " as a Component");
    }
}

