/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.lib.net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.inventory.Book;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.serializer.configurate4.ComponentTypeSerializer;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.ConfigurationNode;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.serialize.TypeSerializer;

final class BookTypeSerializer
implements TypeSerializer<Book> {
    static final BookTypeSerializer INSTANCE = new BookTypeSerializer();
    static final String TITLE = "title";
    static final String AUTHOR = "author";
    static final String PAGES = "pages";

    private BookTypeSerializer() {
    }

    @Override
    public Book deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        Component title = value.node(TITLE).get(Component.class);
        Component author = value.node(AUTHOR).get(Component.class);
        List<Component> pages = value.node(PAGES).get(ComponentTypeSerializer.LIST_TYPE);
        if (title == null || author == null || pages == null) {
            throw new SerializationException("title, author, and pages fields are all required to deserialize a Book");
        }
        return Book.book(title, author, pages);
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Book obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(TITLE).set(Component.class, obj.title());
        value.node(AUTHOR).set(Component.class, obj.author());
        value.node(PAGES).set(ComponentTypeSerializer.LIST_TYPE, obj.pages());
    }
}

