/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.text.StringCharacterIterator;
import java.util.stream.IntStream;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.util.Components;
import xyz.jpenilla.tabtps.common.util.Gradient;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.ComponentLike;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TextComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.event.HoverEventSource;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.NamedTextColor;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextColor;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextDecoration;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;

public final class MemoryUtil {
    private MemoryUtil() {
    }

    public static int usedMemory() {
        return Math.round((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed() / 1048576.0f);
    }

    public static int committedMemory() {
        return Math.round((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getCommitted() / 1048576.0f);
    }

    public static int maxMemory() {
        return Math.round((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() / 1048576.0f);
    }

    public static @NonNull Component renderBar(@NonNull MemoryUsage usage, int barLength) {
        return MemoryUtil.renderBarImpl(null, usage, barLength);
    }

    public static @NonNull Component renderBar(@NonNull String name, @NonNull MemoryUsage usage, int barLength) {
        return MemoryUtil.renderBarImpl(name, usage, barLength);
    }

    private static @NonNull Component renderBarImpl(@Nullable String name, @NonNull MemoryUsage usage, int barLength) {
        long used = usage.getUsed();
        long committed = usage.getCommitted();
        long max = usage.getMax();
        long init = usage.getInit();
        long adjustedMax = max == -1L ? committed : max;
        long adjustedInit = init == -1L ? 0L : init;
        float usedPercent = (float)used / (float)adjustedMax;
        float committedPercent = (float)committed / (float)adjustedMax;
        float initPercent = (float)adjustedInit / (float)adjustedMax;
        int usedLength = Math.round((float)barLength * usedPercent);
        int committedLength = Math.round((float)barLength * (committedPercent - usedPercent));
        int unallocatedLength = barLength - usedLength - committedLength;
        int initPointer = Math.min(barLength, Math.max(1, Math.round((float)barLength * initPercent)));
        Gradient usedGradient = new Gradient(NamedTextColor.GREEN, NamedTextColor.DARK_GREEN);
        Gradient committedGradient = new Gradient(NamedTextColor.AQUA, NamedTextColor.BLUE);
        Gradient unallocatedGradient = new Gradient(NamedTextColor.GRAY, NamedTextColor.DARK_GRAY);
        usedGradient.length(usedLength);
        committedGradient.length(committedLength);
        unallocatedGradient.length(unallocatedLength);
        TextComponent.Builder builder = Component.text();
        TextComponent.Builder hover = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(MemoryUtil.humanReadableByteCountBin(used))).append((Component)Component.space())).append((Component)Messages.LABEL_USED.styled((TextColor)NamedTextColor.WHITE, new ComponentLike[0]))).append((Component)Component.text("/", (TextColor)NamedTextColor.GRAY))).append(MemoryUtil.humanReadableByteCountBin(committed))).append((Component)Component.space())).append((Component)Messages.LABEL_ALLOCATED.styled((TextColor)NamedTextColor.WHITE, new ComponentLike[0]))).append((Component)Component.newline());
        if (max != -1L) {
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)hover.append(MemoryUtil.humanReadableByteCountBin(adjustedMax))).append((Component)Component.space())).append((Component)Messages.LABEL_MAXIMUM.styled((TextColor)NamedTextColor.WHITE, new ComponentLike[0]))).append((Component)Component.text(",", (TextColor)NamedTextColor.GRAY))).append((Component)Component.space());
        }
        ((TextComponent.Builder)((TextComponent.Builder)hover.append(MemoryUtil.humanReadableByteCountBin(adjustedInit))).append((Component)Component.space())).append((ComponentLike)Messages.LABEL_INITIAL_AMOUNT);
        builder.hoverEvent((HoverEventSource)hover.build());
        builder.append((Component)Component.text("[", (TextColor)NamedTextColor.GRAY));
        IntStream.rangeClosed(1, barLength).forEach(i -> {
            if (i == initPointer) {
                builder.append((Component)Component.text("|", TextColor.color(16730280)));
            } else if (i <= usedLength) {
                builder.append((Component)Component.text("|", usedGradient.nextColor()));
            } else if (i <= usedLength + committedLength) {
                builder.append((Component)Component.text("|", committedGradient.nextColor()));
            } else {
                builder.append((Component)Component.text("|", unallocatedGradient.nextColor()));
            }
        });
        builder.append((Component)Component.text("]", (TextColor)NamedTextColor.GRAY));
        if (name != null && !name.isEmpty()) {
            builder.append(Component.space(), Component.text(name, (TextColor)NamedTextColor.WHITE, TextDecoration.ITALIC));
        }
        return builder.build();
    }

    public static @NonNull Component humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return Components.ofChildren(Components.gradient(String.valueOf(bytes), NamedTextColor.BLUE, NamedTextColor.AQUA), Component.text("B", (TextColor)NamedTextColor.GRAY));
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return Components.ofChildren(Components.gradient(String.format("%.1f", (double)(value *= (long)Long.signum(bytes)) / 1024.0), NamedTextColor.BLUE, NamedTextColor.AQUA), Component.text(String.format("%ciB", Character.valueOf(ci.current())), (TextColor)NamedTextColor.GRAY));
    }
}

