/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.util;

import java.util.Arrays;
import java.util.Collections;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextColor;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;

public final class Gradient {
    private int index = 0;
    private int colorIndex = 0;
    private float factorStep = 0.0f;
    private float phase;
    private final boolean negativePhase;
    private final TextColor[] colors;

    public Gradient(TextColor ... colors) {
        this(0.0f, colors);
    }

    public Gradient(float phase, TextColor ... colors) {
        if (colors.length < 2) {
            throw new IllegalArgumentException("Gradients must have at least two colors! colors=" + Arrays.toString(colors));
        }
        if ((double)phase > 1.0 || (double)phase < -1.0) {
            throw new IllegalArgumentException(String.format("Phase must be in range [-1, 1]. '%s' is not valid.", Float.valueOf(phase)));
        }
        this.colors = colors;
        if (phase < 0.0f) {
            this.negativePhase = true;
            this.phase = 1.0f + phase;
            Collections.reverse(Arrays.asList(this.colors));
        } else {
            this.negativePhase = false;
            this.phase = phase;
        }
    }

    public void length(int size) {
        this.colorIndex = 0;
        this.index = 0;
        int sectorLength = size / (this.colors.length - 1);
        this.factorStep = 1.0f / (float)sectorLength;
        this.phase *= (float)sectorLength;
    }

    public @NonNull TextColor nextColor() {
        if (this.factorStep * (float)this.index > 1.0f) {
            ++this.colorIndex;
            this.index = 0;
        }
        int n = this.index++;
        float factor = this.factorStep * ((float)n + this.phase);
        if (factor > 1.0f) {
            factor = 1.0f - (factor - 1.0f);
        }
        if (this.negativePhase && this.colors.length % 2 != 0) {
            return this.interpolate(this.colors[this.colorIndex + 1], this.colors[this.colorIndex], factor);
        }
        return this.interpolate(this.colors[this.colorIndex], this.colors[this.colorIndex + 1], factor);
    }

    private @NonNull TextColor interpolate(@NonNull TextColor color1, @NonNull TextColor color2, float factor) {
        return TextColor.color(Math.round((float)color1.red() + factor * (float)(color2.red() - color1.red())), Math.round((float)color1.green() + factor * (float)(color2.green() - color1.green())), Math.round((float)color1.blue() + factor * (float)(color2.blue() - color1.blue())));
    }
}

