/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.util;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import xyz.jpenilla.tabtps.common.util.Gradient;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.ComponentLike;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TextComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.Style;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextColor;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.tabtps.lib.org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class Components {
    public static final Pattern SPECIAL_CHARACTERS_PATTERN = Pattern.compile("[^\\s\\w\\-]");

    private Components() {
    }

    public static Component highlight(Component component, TextColor highlightColor) {
        return component.replaceText(config -> {
            config.match(SPECIAL_CHARACTERS_PATTERN);
            config.replacement(match -> match.color(highlightColor));
        });
    }

    public static Component gradient(String textContent, @Nullable Consumer<Style.Builder> style, TextColor ... colors) {
        Gradient gradient = new Gradient(colors);
        TextComponent.Builder builder = Component.text();
        if (style != null) {
            builder.style(style);
        }
        char[] content = textContent.toCharArray();
        gradient.length(content.length);
        for (char c : content) {
            builder.append((Component)Component.text(c, gradient.nextColor()));
        }
        return builder.build();
    }

    public static Component gradient(String textContent, TextColor ... colors) {
        return Components.gradient(textContent, null, colors);
    }

    public static TextComponent ofChildren(ComponentLike ... children) {
        if (children.length == 0) {
            return Component.empty();
        }
        return (TextComponent)((TextComponent.Builder)Component.text().append(children)).build();
    }
}

