/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.module;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.config.Theme;
import xyz.jpenilla.tabtps.common.module.CPUModule;
import xyz.jpenilla.tabtps.common.module.MSPTModule;
import xyz.jpenilla.tabtps.common.module.MemoryModule;
import xyz.jpenilla.tabtps.common.module.Module;
import xyz.jpenilla.tabtps.common.module.PingModule;
import xyz.jpenilla.tabtps.common.module.PlayerCountModule;
import xyz.jpenilla.tabtps.common.module.TPSModule;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;

public final class ModuleType<T extends Module> {
    private static final Map<String, ModuleType<? extends Module>> TYPES_BY_NAME = new HashMap<String, ModuleType<? extends Module>>();
    private static final Map<Class<? extends Module>, ModuleType<? extends Module>> TYPES_BY_CLASS = new HashMap<Class<? extends Module>, ModuleType<? extends Module>>();
    public static final ModuleType<CPUModule> CPU = ModuleType.withoutPlayer(CPUModule.class, CPUModule::new, "cpu");
    public static final ModuleType<MemoryModule> MEMORY = ModuleType.withoutPlayer(MemoryModule.class, MemoryModule::new, "memory");
    public static final ModuleType<MSPTModule> MSPT = ModuleType.withoutPlayer(MSPTModule.class, MSPTModule::new, "mspt");
    public static final ModuleType<TPSModule> TPS = ModuleType.withoutPlayer(TPSModule.class, TPSModule::new, "tps");
    public static final ModuleType<PingModule> PING = ModuleType.withPlayer(PingModule.class, PingModule::new, "ping");
    public static final ModuleType<PlayerCountModule> PLAYER_COUNT = ModuleType.withoutPlayer(PlayerCountModule.class, PlayerCountModule::new, "players");
    private final Class<T> moduleClass;
    private final ModuleFactory<T> moduleFactory;
    private final String name;
    private final boolean needsPlayer;

    public static Collection<ModuleType<?>> moduleTypes() {
        return Collections.unmodifiableCollection(TYPES_BY_NAME.values());
    }

    public static @NonNull ModuleType<? extends Module> fromName(@NonNull String name) {
        ModuleType<? extends Module> type = TYPES_BY_NAME.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Unknown or invalid module type: " + name);
        }
        return type;
    }

    public static <T extends Module> @NonNull ModuleType<T> fromClass(@NonNull Class<T> moduleClass) {
        ModuleType<? extends Module> type = TYPES_BY_CLASS.get(moduleClass);
        if (type == null) {
            throw new IllegalArgumentException("Unknown or invalid module class: " + moduleClass.getSimpleName());
        }
        return type;
    }

    private static <T extends Module> @NonNull ModuleType<T> withoutPlayer(@NonNull Class<T> moduleClass, @NonNull BiFunction<@NonNull TabTPS, @NonNull Theme, @NonNull T> moduleFactory, @NonNull String name) {
        return new ModuleType<Module>(moduleClass, (plugin, theme, player) -> (Module)moduleFactory.apply(plugin, theme), name, false);
    }

    private static <T extends Module> @NonNull ModuleType<T> withPlayer(@NonNull Class<T> moduleClass, @NonNull ModuleFactory<T> moduleFactory, @NonNull String name) {
        return new ModuleType<T>(moduleClass, moduleFactory, name, true);
    }

    private ModuleType(@NonNull Class<T> moduleClass, @NonNull ModuleFactory<T> moduleFactory, @NonNull String name, boolean needsPlayer) {
        this.moduleClass = moduleClass;
        this.moduleFactory = moduleFactory;
        this.name = name;
        this.needsPlayer = needsPlayer;
        TYPES_BY_NAME.put(name, this);
        TYPES_BY_CLASS.put(moduleClass, this);
    }

    public @NonNull String name() {
        return this.name;
    }

    public boolean needsPlayer() {
        return this.needsPlayer;
    }

    public @NonNull Class<T> moduleClass() {
        return this.moduleClass;
    }

    public @NonNull T createModule(@NonNull TabTPS tabTPS, @NonNull Theme theme, @Nullable User<?> user) {
        if (this.needsPlayer && user == null) {
            throw new IllegalArgumentException(String.format("Module type '%s' requires a player", this.name));
        }
        return this.moduleFactory.create(tabTPS, theme, user);
    }

    @FunctionalInterface
    private static interface ModuleFactory<T extends Module> {
        public @NonNull T create(@NonNull TabTPS var1, @NonNull Theme var2, @Nullable User<?> var3);
    }
}

