/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.config.Theme;
import xyz.jpenilla.tabtps.common.module.Module;
import xyz.jpenilla.tabtps.common.module.ModuleType;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TextComponent;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;

public final class ModuleRenderer {
    private final List<Module> modules;
    private final Function<Module, Component> moduleRenderFunction;
    private final Component separator;

    public static @NonNull Function<Module, Component> standardRenderFunction(@NonNull Theme theme) {
        return module -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(module.label())).append((Component)Component.text(":", theme.colorScheme().textSecondary()))).append((Component)Component.space())).append(module.display())).build();
    }

    private ModuleRenderer(@NonNull List<Module> modules, @NonNull Function<Module, Component> moduleRenderFunction, @Nullable Component separator) {
        this.modules = modules;
        this.moduleRenderFunction = moduleRenderFunction;
        this.separator = separator;
    }

    public @NonNull Component render() {
        TextComponent.Builder builder = Component.text();
        Iterator<Module> iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            Module module = iterator.next();
            builder.append(this.moduleRenderFunction.apply(module));
            if (!iterator.hasNext()) continue;
            builder.append(Objects.requireNonNull(this.separator, "separator is null but there is more than one module"));
        }
        return builder.build();
    }

    public int moduleCount() {
        return this.modules.size();
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Module> modules = new ArrayList<Module>();
        private Function<Module, Component> moduleRenderFunction;
        private Component separator = null;

        private Builder() {
        }

        public @NonNull Builder moduleRenderFunction(@NonNull Function<Module, Component> function) {
            this.moduleRenderFunction = function;
            return this;
        }

        public @NonNull Builder separator(@NonNull Component separator) {
            this.separator = separator;
            return this;
        }

        public @NonNull Builder modules(@NonNull List<Module> modules) {
            this.modules.clear();
            this.modules.addAll(modules);
            return this;
        }

        public @NonNull Builder modules(Module ... modules) {
            return this.modules(Arrays.asList(modules));
        }

        public @NonNull Builder modules(@NonNull TabTPS tabTPS, @NonNull Theme theme, @NonNull String modules) {
            return this.modules(tabTPS, theme, null, modules);
        }

        public @NonNull Builder modules(@NonNull TabTPS tabTPS, @NonNull Theme theme, @Nullable User<?> player, @NonNull String modules) {
            return this.modules(Arrays.stream(modules.replace(" ", "").split(",")).filter(s -> s != null && !s.isEmpty()).map(ModuleType::fromName).filter(type -> !type.needsPlayer() || player != null).map(type -> type.createModule(tabTPS, theme, player)).collect(Collectors.toList()));
        }

        public @NonNull ModuleRenderer build() throws IllegalArgumentException {
            if (this.separator == null && this.modules.size() > 1) {
                throw new IllegalArgumentException("separator is null but there is more than one module");
            }
            if (this.moduleRenderFunction == null) {
                throw new IllegalArgumentException("must provide a module render function");
            }
            return new ModuleRenderer(this.modules, this.moduleRenderFunction, this.separator);
        }
    }
}

