/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.display.task;

import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.config.DisplayConfig;
import xyz.jpenilla.tabtps.common.config.Theme;
import xyz.jpenilla.tabtps.common.display.Display;
import xyz.jpenilla.tabtps.common.module.ModuleRenderer;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;

public final class TabDisplayTask
implements Display {
    private final ModuleRenderer headerRenderer;
    private final ModuleRenderer footerRenderer;
    private final User<?> user;

    public TabDisplayTask(@NonNull TabTPS tabTPS, @NonNull User<?> user, @NonNull DisplayConfig.TabSettings settings) {
        Theme theme = tabTPS.configManager().theme(settings.theme());
        this.headerRenderer = ModuleRenderer.builder().modules(tabTPS, tabTPS.configManager().theme(settings.theme()), user, settings.headerModules()).separator(settings.separator()).moduleRenderFunction(ModuleRenderer.standardRenderFunction(theme)).build();
        this.footerRenderer = ModuleRenderer.builder().modules(tabTPS, tabTPS.configManager().theme(settings.theme()), user, settings.footerModules()).separator(settings.separator()).moduleRenderFunction(ModuleRenderer.standardRenderFunction(theme)).build();
        this.user = user;
    }

    @Override
    public void run() {
        if (!this.user.online()) {
            this.user.tab().stopDisplay();
            return;
        }
        if (this.headerRenderer.moduleCount() > 0) {
            this.user.sendPlayerListHeader(this.headerRenderer.render());
        }
        if (this.footerRenderer.moduleCount() > 0) {
            this.user.sendPlayerListFooter(this.footerRenderer.render());
        }
    }

    @Override
    public void disable() {
        if (this.user.online()) {
            this.user.sendPlayerListHeaderAndFooter(Component.empty(), Component.empty());
        }
    }
}

