/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.display;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.config.DisplayConfig;
import xyz.jpenilla.tabtps.common.display.Display;
import xyz.jpenilla.tabtps.common.util.RunnableFuturePair;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;

public final class DisplayHandler<D extends Display> {
    private final transient TabTPS tabTPS;
    private final transient User<?> user;
    private final transient Function<DisplayConfig, D> displayFactory;
    private final transient int updateRate;
    private transient RunnableFuturePair<D> futurePair = null;
    private boolean enabled = false;

    public DisplayHandler(@NonNull TabTPS tabTPS, @NonNull User<?> user, int updateRate, @NonNull Function<DisplayConfig, D> displayFactory) {
        this.tabTPS = tabTPS;
        this.user = user;
        this.updateRate = updateRate;
        this.displayFactory = displayFactory;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void startDisplay() {
        this.stopDisplay();
        this.tabTPS.findDisplayConfig(this.user).ifPresent(config -> {
            Display task = (Display)this.displayFactory.apply((DisplayConfig)config);
            ScheduledFuture<?> future = this.tabTPS.executor().scheduleAtFixedRate(task, 0L, this.updateRate, TimeUnit.MILLISECONDS);
            this.futurePair = new RunnableFuturePair<Display>(task, future);
        });
    }

    public void stopDisplay() {
        if (this.futurePair != null) {
            this.futurePair.future().cancel(false);
            ((Display)this.futurePair.runnable()).disable();
            this.futurePair = null;
        }
    }
}

