/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.config;

import java.util.Objects;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.bossbar.BossBar;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public final class DisplayConfig {
    private static final String SEPARATOR_COMMENT = "The text used to separate modules. Accepts MiniMessage (i.e. \" <gray>|</gray> \")";
    @Comment(value="The permission required to use this display config\nCan be an empty string (\"\") to require no permission")
    private String permission = "tabtps.defaultdisplay";
    private ActionBarSettings actionBarSettings = new ActionBarSettings();
    private BossBarSettings bossBarSettings = new BossBarSettings();
    private TabSettings tabSettings = new TabSettings();

    public @NonNull String permission() {
        return this.permission;
    }

    public @NonNull ActionBarSettings actionBarSettings() {
        return this.actionBarSettings;
    }

    public @NonNull BossBarSettings bossBarSettings() {
        return this.bossBarSettings;
    }

    public @NonNull TabSettings tabSettings() {
        return this.tabSettings;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisplayConfig)) {
            return false;
        }
        DisplayConfig that = (DisplayConfig)o;
        return this.permission.equals(that.permission) && this.actionBarSettings.equals(that.actionBarSettings) && this.bossBarSettings.equals(that.bossBarSettings) && this.tabSettings.equals(that.tabSettings);
    }

    public int hashCode() {
        return Objects.hash(this.permission, this.actionBarSettings, this.bossBarSettings, this.tabSettings);
    }

    @ConfigSerializable
    public static final class ActionBarSettings
    implements DisplaySettings {
        private boolean allow = true;
        private boolean enableOnLogin = false;
        private String modules = "tps,mspt,ping";
        private String theme = "default";
        @Comment(value="The text used to separate modules. Accepts MiniMessage (i.e. \" <gray>|</gray> \")")
        private Component separator = Component.space();

        @Override
        public @NonNull Component separator() {
            return this.separator;
        }

        @Override
        public boolean enableOnLogin() {
            return this.enableOnLogin;
        }

        @Override
        public boolean allow() {
            return this.allow;
        }

        public @NonNull String modules() {
            return this.modules;
        }

        @Override
        public @NonNull String theme() {
            return this.theme;
        }
    }

    @ConfigSerializable
    public static final class BossBarSettings
    implements DisplaySettings {
        private boolean allow = true;
        private boolean enableOnLogin = false;
        private String modules = "tps,mspt,ping";
        private String theme = "default";
        @Comment(value="Available colors: [PINK, RED, GREEN, BLUE, YELLOW, PURPLE, WHITE]")
        private Colors colors = new Colors();
        @Comment(value="Set the mode for determining boss bar fill.\nPossible values: [MSPT, TPS, REVERSE_MSPT, REVERSE_TPS]")
        private FillMode fillMode = FillMode.MSPT;
        @Comment(value="What kind of overlay should be used for the boss bar?\nMust be one of: [PROGRESS, NOTCHED_6, NOTCHED_10, NOTCHED_12, NOTCHED_20]")
        private BossBar.Overlay overlay = BossBar.Overlay.NOTCHED_20;
        @Comment(value="The text used to separate modules. Accepts MiniMessage (i.e. \" <gray>|</gray> \")")
        private Component separator = Component.space();

        @Override
        public @NonNull Component separator() {
            return this.separator;
        }

        @Override
        public boolean allow() {
            return this.allow;
        }

        @Override
        public boolean enableOnLogin() {
            return this.enableOnLogin;
        }

        public @NonNull String modules() {
            return this.modules;
        }

        public @NonNull FillMode fillMode() {
            return this.fillMode;
        }

        public  @NonNull BossBar.Overlay overlay() {
            return this.overlay;
        }

        public @NonNull Colors colors() {
            return this.colors;
        }

        @Override
        public @NonNull String theme() {
            return this.theme;
        }

        @ConfigSerializable
        public static final class Colors {
            private BossBar.Color lowPerformance = BossBar.Color.RED;
            private BossBar.Color mediumPerformance = BossBar.Color.YELLOW;
            private BossBar.Color goodPerformance = BossBar.Color.GREEN;

            public  @NonNull BossBar.Color lowPerformance() {
                return this.lowPerformance;
            }

            public  @NonNull BossBar.Color mediumPerformance() {
                return this.mediumPerformance;
            }

            public  @NonNull BossBar.Color goodPerformance() {
                return this.goodPerformance;
            }
        }

        public static enum FillMode {
            TPS,
            MSPT,
            REVERSE_TPS,
            REVERSE_MSPT;

        }
    }

    @ConfigSerializable
    public static final class TabSettings
    implements DisplaySettings {
        private boolean allow = true;
        private boolean enableOnLogin = false;
        private String headerModules = "";
        private String footerModules = "tps,mspt";
        private String theme = "default";
        @Comment(value="The text used to separate modules. Accepts MiniMessage (i.e. \" <gray>|</gray> \")")
        private Component separator = Component.space();

        @Override
        public @NonNull Component separator() {
            return this.separator;
        }

        @Override
        public boolean enableOnLogin() {
            return this.enableOnLogin;
        }

        @Override
        public boolean allow() {
            return this.allow;
        }

        public @NonNull String headerModules() {
            return this.headerModules;
        }

        public @NonNull String footerModules() {
            return this.footerModules;
        }

        @Override
        public @NonNull String theme() {
            return this.theme;
        }
    }

    public static interface DisplaySettings {
        public boolean allow();

        public boolean enableOnLogin();

        public @NonNull String theme();

        public @NonNull Component separator();
    }
}

