/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import xyz.jpenilla.tabtps.common.config.ConfigLoader;
import xyz.jpenilla.tabtps.common.config.DisplayConfig;
import xyz.jpenilla.tabtps.common.config.PluginSettings;
import xyz.jpenilla.tabtps.common.config.Theme;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.ConfigurateException;

public final class ConfigManager {
    private final Path dataDirectory;
    private final ConfigLoader<PluginSettings> pluginSettingsLoader;
    private PluginSettings pluginSettings;
    private final Path displayConfigsPath;
    private final Map<DisplayConfig, ConfigLoader<DisplayConfig>> displayConfigs = new HashMap<DisplayConfig, ConfigLoader<DisplayConfig>>();
    private final Map<String, DisplayConfig> displayConfigsByPermission = new HashMap<String, DisplayConfig>();
    private final Path themePath;
    private final Map<Theme, ConfigLoader<Theme>> themes = new HashMap<Theme, ConfigLoader<Theme>>();
    private final Map<String, Theme> themesByName = new HashMap<String, Theme>();

    public ConfigManager(@NonNull Path dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.pluginSettingsLoader = new ConfigLoader<PluginSettings>(PluginSettings.class, this.dataDirectory.resolve("main.conf"), options -> options.header("TabTPS main plugin settings"));
        this.displayConfigsPath = this.dataDirectory.resolve("display-configs");
        this.themePath = this.dataDirectory.resolve("themes");
    }

    public void load() throws ConfigurateException {
        List paths;
        List existingFiles;
        ConfigManager.tryCreateDirectoryIfNeeded(this.dataDirectory);
        this.pluginSettings = this.pluginSettingsLoader.load();
        ConfigManager.tryCreateDirectoryIfNeeded(this.themePath);
        try {
            this.themes.clear();
            this.themesByName.clear();
            existingFiles = Files.list(this.themePath).collect(Collectors.toList());
            paths = existingFiles.size() != 0 ? existingFiles : Collections.singletonList(this.themePath.resolve("default.conf"));
            for (Path path : paths) {
                if (!path.toString().endsWith(".conf")) continue;
                ConfigLoader<Theme> loader = new ConfigLoader<Theme>(Theme.class, path, options -> options.header("Theme"));
                Theme config = loader.load();
                this.themes.put(config, loader);
                this.themesByName.put(path.getFileName().toString().split("\\.")[0], config);
            }
        }
        catch (IOException e) {
            throw new ConfigurateException("Failed to load themes", (Throwable)e);
        }
        ConfigManager.tryCreateDirectoryIfNeeded(this.displayConfigsPath);
        try {
            this.displayConfigs.clear();
            this.displayConfigsByPermission.clear();
            existingFiles = Files.list(this.displayConfigsPath).collect(Collectors.toList());
            paths = existingFiles.size() != 0 ? existingFiles : Collections.singletonList(this.displayConfigsPath.resolve("default.conf"));
            HashSet<String> usedPermissions = new HashSet<String>();
            for (Path path : paths) {
                if (!path.toString().endsWith(".conf")) continue;
                ConfigLoader<DisplayConfig> loader = new ConfigLoader<DisplayConfig>(DisplayConfig.class, path, options -> options.header("TabTPS display configuration\n\n   Available modules: [tps, mspt, memory, ping, cpu, players]\n   Modules are configured in comma separated format, i.e. \"cpu,tps,mspt\", \"ping\", or \"\" (no modules)"));
                DisplayConfig config = loader.load();
                if (usedPermissions.contains(config.permission())) {
                    throw new ConfigurateException(String.format("Cannot load config with duplicate permission '%s': %s", config.permission(), path));
                }
                usedPermissions.add(config.permission());
                this.displayConfigs.put(config, loader);
                this.displayConfigsByPermission.put(config.permission(), config);
            }
        }
        catch (IOException e) {
            throw new ConfigurateException("Failed to load display configs", (Throwable)e);
        }
        Set permissions = this.displayConfigs.keySet().stream().map(DisplayConfig::permission).collect(Collectors.toSet());
        this.pluginSettings.permissionPriorities().addAll(permissions);
        this.pluginSettings.permissionPriorities().removeIf(p -> !permissions.contains(p));
        this.save();
    }

    public void save() throws ConfigurateException {
        this.pluginSettingsLoader.save(this.pluginSettings);
        for (Map.Entry<DisplayConfig, ConfigLoader<DisplayConfig>> entry : this.displayConfigs.entrySet()) {
            entry.getValue().save(entry.getKey());
        }
        for (Map.Entry<Object, ConfigLoader<Object>> entry : this.themes.entrySet()) {
            entry.getValue().save((Theme)entry.getKey());
        }
    }

    public @NonNull PluginSettings pluginSettings() {
        return this.pluginSettings;
    }

    public @NonNull Collection<DisplayConfig> displayConfigs() {
        return Collections.unmodifiableSet(this.displayConfigs.keySet());
    }

    public @NonNull Theme theme(@NonNull String name) {
        Theme theme = this.themesByName.get(name);
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Uh oh! No theme found with the name '%s'. Available themes: [%s]", name, String.join((CharSequence)", ", this.themesByName.keySet())));
        }
        return theme;
    }

    public @NonNull Map<String, DisplayConfig> displayConfigsByPermission() {
        return this.displayConfigsByPermission;
    }

    private static void tryCreateDirectoryIfNeeded(@NonNull Path directory) {
        if (Files.exists(directory, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectory(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create directory: " + directory, e);
        }
    }
}

