/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.config;

import java.nio.file.Path;
import java.util.function.UnaryOperator;
import xyz.jpenilla.tabtps.common.util.Serializers;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.CommentedConfigurationNode;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.ConfigurateException;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.ConfigurationOptions;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.objectmapping.ObjectMapper;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.tabtps.lib.org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class ConfigLoader<C> {
    private static final TypeSerializerCollection SERIALIZERS = TypeSerializerCollection.defaults().childBuilder().registerAll(ConfigurateComponentSerializer.builder().scalarSerializer(Serializers.MINIMESSAGE).outputStringComponents(true).build().serializers()).build();
    private final HoconConfigurationLoader loader;
    private final ObjectMapper<C> mapper;

    public ConfigLoader(@NonNull Class<C> configClass, @NonNull Path configPath, @NonNull ConfigurationOptions options) {
        try {
            this.mapper = ObjectMapper.factory().get(configClass);
        }
        catch (SerializationException ex) {
            throw new IllegalStateException("Failed to initialize an object mapper for type: " + configClass.getSimpleName(), ex);
        }
        this.loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(configPath)).defaultOptions(options.serializers(builder -> builder.registerAll(SERIALIZERS).registerAnnotatedObjects(ObjectMapper.factory())))).build();
    }

    public ConfigLoader(@NonNull Class<C> configClass, @NonNull Path configPath, @NonNull UnaryOperator<ConfigurationOptions> options) {
        this(configClass, configPath, (ConfigurationOptions)options.apply(ConfigurationOptions.defaults()));
    }

    public ConfigLoader(@NonNull Class<C> configClass, @NonNull Path configPath) {
        this(configClass, configPath, ConfigurationOptions.defaults());
    }

    public @NonNull C load() throws ConfigurateException {
        CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.load();
        return this.mapper.load(node);
    }

    public void save(@NonNull C config) throws ConfigurateException {
        CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.createNode();
        this.mapper.save(config, node);
        this.loader.save(node);
    }
}

